<?php

namespace App\TelegramBot\Handlers;

use App\Models\kino;
use App\Models\serials;
use App\TelegramBot\Api;
use App\TelegramBot\Keyboard\Keyboard;
use App\TelegramBot\Keyboard\BRow;
use App\Models\user;

class MainHandler{


    public function __construct($user,$token)
    {
        $this->user = $user;
        $this->api = new Api($user->chat_id,$token);
        $this->defaultMedia = "https://te.legra.ph/file/0de9915d7d100dc6fc55b.png";
        $this->genres = ["Триллеры","Драмы","Мистика","Мелодрама","Комедия","Мюзикл","Приключения","Фантастика","Ужасы","Криминал","Фэнтези","Боевики","Семейный","Спорт","Документальные","Исторический","Аниме","Короткометражка","Детский"];
    }

    public function main(){

        $kb = new Keyboard();

        $kb = $kb->addRow(BRow::createRow()
            ->addButton("📺 Список сериалов",[
                'action'=>'main@list',
                'data'=>[
                    'data' => [0,false]
                ]
            ])
            ->addButton("🔎 Поиск сериала",['action'=>'main@search'])->get());

        $kb = $kb->addRow(BRow::createRow()
            ->addButton("🔍 Поиск фильма",['action'=>'main@search_film'])->get());
        $kb = $kb->get($this->user);

        $this->api->execute("sendMessage",[
            "text" => "Привет!\n\nЯ помогу тебе найти тысячи фильмов и сериалов 😉\n\n[Подпишись на канал, чтобы не пропустить новинки ⚡️](t.me/smotri_kino_serial)",
            "keyboard" => $kb
        ]);


    }

    public function films(){

        $this->api->execute('sendMessage',[
            'text'=>"Список фильмов больше недоступен, воспользуйтесь поиском.",
        ]);
    }

    public function filmsByGenre($data){

        $films = kino::where('genre', 'LIKE', "%{$this->genres[$data->data[0]]}%")->offset($data->data[1] * 4)->take(4)->get();

        $count_films = kino::where('genre', 'LIKE', "%{$this->genres[$data->data[0]]}%")->count();
        $count_pages = round($count_films/4);
        $text = "";
        $f = 1;
        $links = [];




        foreach ($films as $film) {
            $desc = strip_tags($film->description);
            $desc = mb_substr($desc,0,150);
            $desc = "{$desc}..";
            $film['name'] = str_replace("&nbsp;"," ",$film->name);
            $text.="`[{$f}]` *{$film->name} ({$film->year})*`";
            $text.=" [imdb:{$film->imdb}] [kp:{$film->kp}]\n";
            $text.="{$desc}`\n\n";
            switch ($f){
                case 1:
                    $links[] = ['text' => "1️⃣", 'callback_data' => "main:film:genre:{$film->id}:{$data->data[0]}:{$data->data[1]}"];
                    break;
                case 2:
                    $links[] = ['text' => "2️⃣", 'callback_data' => "main:film:genre:{$film->id}:{$data->data[0]}:{$data->data[1]}"];
                    break;
                case 3:
                    $links[] = ['text' => "3️⃣", 'callback_data' => "main:film:genre:{$film->id}:{$data->data[0]}:{$data->data[1]}"];
                    break;
                case 4:
                    $links[] = ['text' => "4️⃣", 'callback_data' => "main:film:genre:{$film->id}:{$data->data[0]}:{$data->data[1]}"];
                    break;
            }
            $f++;
        }
        $text.="\n🎬 Наш канал - [@smotri_kino_serial](t.me/smotri_kino_serial)";

        $buttons = [];
        $page_str = $data->data[1]+1;
        if($page_str>1){
            $pp = $data->data[1]-1;
            $prev_page = ['text' => "« назад", 'callback_data' => "main:filmsByGenre:{$data->data[0]}:{$pp}"];
            $buttons[] = $prev_page;
        }
        $curr_page = $data->data[1]+1;
        $buttons[] = ['text' => "[ страница {$curr_page} ]", 'callback_data' => "empty"];
        if($page_str<$count_pages){
            $np = $data->data[1] +1;
            $next = $data->data[1]+2;
            $next_page = ['text' => "вперёд »", 'callback_data' => "main:filmsByGenre:{$data->data[0]}:{$np}"];
            $buttons[] = $next_page;
        }
        $this->api->execute('editMessageText', [
            'text'=>$text,
            'message_id'=>$data->message_id,
            'inline_keyboard' => [
                $links,
                $buttons,
                [
                    ['text' => "<- К жанрам", 'callback_data' => "main:backToGenres"]
                ]
            ]
        ]);
    }

    public function backToGenres($data){
        $this->api->execute("deleteMessage",[
            "message_id" => $data->message_id
        ]);
        $this->films();
    }


    public function film($data){

        $film = kino::where('id', $data->data[1])->first();

        $film->name = str_replace("&nbsp;"," ",$film->name);
        $desc = strip_tags($film->description);
        $txt = "*{$film->name} ({$film->year})*\n\n";
        $txt .= "`IMDB:` {$film->imdb}\n";
        $txt .= "`KP:` {$film->kp}\n";
        $txt .= "`Страна:` {$film->country}\n";
        $txt .= "`Год:` {$film->year}\n";
        if (strpos($film['translation'],"Плеер") === false) {
            $txt .= "`Перевод:` {$film->translation}\n";
        }
        $txt .= "`Актёры:` {$film->actors}\n\n";
        $txt .= "_{$desc}_";
        $buttons = [];
        $buttons[] = [['text' => "Смотреть", 'callback_data' => "main:watch:{$film->id}"]];


        if($data->data[0]=='search') {
            $buttons[] = [['text' => "<- Назад", 'callback_data' => "main:films_list:{$data->data[3]}"]];
            $this->api->execute('editMessageText',['text'=>$txt,'message_id'=>$data->message_id,'inline_keyboard' => $buttons]);
        }else{
            $buttons[] = [['text' => "<- Назад", 'callback_data' => "main:filmsByGenre:{$data->data[2]}:{$data->data[3]}"]];
            $this->api->execute('editMessageText',['text'=>$txt,'message_id'=>$data->message_id,'inline_keyboard' => $buttons]);
        }
    }


    public function watch($data){
        $film = kino::where('id', $data->data[0])->first();
        $film['name'] = str_replace("&nbsp;"," ",$film->name);

        if($this->user->count_actions>=2 and  $this->user->subscribe==0){
            return $this->api->execute("sendMessage",[
                "text" => "Для того, чтобы продолжить пользоваться ботом, подпишитесь на наш канал 🎬 - [@smotri_kino_serial](t.me/smotri_kino_serial)",
                "inline_keyboard" => [
                    [["text" => "Я подписался","callback_data" => "main:check_subscribe"]]
                ]
            ]);
        }

        $channels = [
            1 => "-1001437153221",
            2 => "-1001229892759",
            3 => "-1001412376088",
            4 => "-1001167680797",
            5 => "-1001219802857",
        ];

        $this->api->execute('sendVideo',[
            'token'=>"928067698:AAG04CcwBx0g9mgBTfAhAwl8W1cl58vWhCY",
            "chat_id" => $channels[rand(1,5)],
            'video'=>$film->file_id,
        ]);

        $this->api->execute('sendVideo',[
            'token'=>"1037127691:AAGKRla-OwfS3ffe6pglWwvrncP53lGFGn0",
            "chat_id" => $channels[rand(1,5)],
            'video'=>$film->file_id,
        ]);

        $this->api->execute('sendVideo', [
            'video' => $film->file_id,
            'caption' => "{$film->name}\n👉 Больше фильмов: [@smotri_kino_bot](t.me/smotri_kino_bot?start=share)"
        ]);
        $this->user->count_actions +=1;
        $this->user->save();

    }





    public function list($data){

        $offset = $data->data[0];
        if(isset($data->data[1])){
            $search = $data->data[1];
        }else{
            $search = false;
        }



        if($search==true){
            $count_films = serials::where('name','like',"{$this->user->search}")->count();
            $serials = serials::where('name','like',"{$this->user->search}")->orderBy('name','asc')->skip($offset)->take(10)->get();


            if($count_films==0){
                $count_films = serials::where('name','like',"%{$this->user->search}%")->count();
                $serials = serials::where('name','like',"%{$this->user->search}%")->orderBy('name','asc')->skip($offset)->take(10)->get();

            }


            if($count_films==0){
                $this->user->search = explode(" ",$this->user->search);
                if(count($this->user->search)>0){
                    $this->user->search = $this->user->search[0];
                }
                $count_films = serials::where('name','like',"%{$this->user->search}%")->count();
                $serials = serials::where('name','like',"%{$this->user->search}%")->orderBy('name','asc')->skip($offset)->take(10)->get();
            }

            if($count_films==0) {
                $count_films = serials::where('info','like',"%{$this->user->search}%")->count();
                $serials = serials::where('info','like',"%{$this->user->search}%")->orderBy('name','asc')->skip($offset)->take(10)->get();
            }
        }else{
            $count_films = serials::count();
            $serials = serials::orderBy('name','asc')->skip($offset)->take(10)->get();
        }




        if($count_films==0){
            return $this->api->execute("sendMessage",[
                "text" => "Извините, по данному запросу у нас не нашлось сериалов.\n\nЕсли такой сериал существует, то мы постараемся добавить его в ближайшее время."
            ]);
        }

        $prev = $offset-10>0?$offset-10 : 0;
        $next = $offset+10<=$count_films ? $offset+10 : $count_films-10;
        $page = floor($offset/10)+1;
        $buttons = [];

        foreach ($serials as $serial) {
            $buttons[] = [
                ['text'=>$serial->name,'callback_data' => "main:serial:{$serial->id}"]
            ];
        }
        $navigate_buttons = [];

        if($offset>0){
            $navigate_buttons[] = ['text'=>"❮ назад ❮",'callback_data' => "main:list:{$prev}"];
        }
        $navigate_buttons[] = ['text'=>"❮ {$page} ❯",'callback_data' => ".."];
        if($offset < $count_films-10){
            $navigate_buttons[] = ['text'=>"❯ вперёд ❯",'callback_data' => "main:list:{$next}"];
        }
        $buttons[] = $navigate_buttons;

        if(isset($data->message_id)){
            $this->api->execute("editMessageMedia",[
                "media" => json_encode([
                    "type" => "photo",
                    "caption" =>"Список сериалов по алфавиту:",
                    "media" => $this->defaultMedia
                ]),
                "message_id" => $data->message_id,
                "inline_keyboard" => $buttons
            ]);
        }else{
            $this->api->execute("sendPhoto",[
                "photo" => $this->defaultMedia,
                "caption" => "Список сериалов по алфавиту:",
                "inline_keyboard" => $buttons
            ]);
        }
    }



    public function search($data){
        $this->user->action = json_encode([
            'action' => "main@startSearchSerial"
        ]);
        $this->user->save();
        $this->api->execute("sendMessage",[
            "text" => "Введите поисковый запрос:"
        ]);
    }

    public function search_film($data){
        $this->user->action = json_encode([
            'action' => "main@startSearchFilm"
        ]);
        $this->user->save();
        $this->api->execute("sendMessage",[
            "text" => "Введите поисковый запрос:"
        ]);
    }

    public function filmInfo($params){
        $data = $params->data;

        $kp_id = $data[0];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "X-API-KEY: 0d4f1e60-bb9f-4972-bd31-7acd334f2d4f"
        ]);
        curl_setopt($ch, CURLOPT_URL, "https://kinopoiskapiunofficial.tech/api/v2.1/films/{$kp_id}");
        $data = curl_exec($ch);
        curl_close($ch);
        $data = json_decode($data)->data;

        $genres = "";
        foreach ($data->genres as $genre) {
            $genres .= $genre->genre.", ";
        }
        $slogan = "";
        if($data->slogan){
            $slogan = "\n_{$data->slogan}_\n";
        }
        $genres = trim($genres,', ');

        $res = file_get_contents("https://videocdn.tv/api/short?kinopoisk_id={$kp_id}&api_token=Gso9cvEqQFgpbbfJGWIBPO7k4wm9gSNf");
        $result = json_decode($res);

        return $this->api->execute("sendMessage",[
            "text" => "{$data->nameRu}[⠀]({$data->posterUrlPreview}) ({$data->year})\n\nДлительность: {$data->filmLength} ч:мин\n{$slogan}\nЖанр: {$genres}\n\n_{$data->description}_",
            "disable_web_page_preview" => false,
            "inline_keyboard" => [
                [['text' => "Смотреть онлайн","url" => str_replace("//","https://",$result->data[0]->iframe_src)]]
            ]
        ]);

    }


    public function getElementValue($string,$strStart,$strEnd){
        $str_search = strpos($string,$strStart);
        if($str_search===false){
            return false;
        }
        $str_1 = substr($string,$str_search+strlen($strStart));
        $str_search = strpos($str_1,$strEnd);
        $res = substr($str_1,0,$str_search);
        return $res;
    }

    public function startSearchFilm($text){

        $this->user->search = $text;
        $this->user->action = 0;
        $this->user->save();

        $q = urlencode($text);


        $res = file_get_contents("https://videocdn.tv/api/short?title={$q}&api_token=Gso9cvEqQFgpbbfJGWIBPO7k4wm9gSNf");

        $result = json_decode($res);


        if($result->result){
            $buttons = [];
            $l=0;
            foreach ($result->data as $film) {
                if($film->kp_id!=null){
                    $l++;
                    $film->year = explode("-",$film->year)[0];
                    $buttons[] = [['text'=>"{$film->title} - {$film->year}",'callback_data' => "main:filmInfo:{$film->kp_id}"]];
                    if($l>=10){
                        break;
                    }
                }

            }
            return $this->api->execute("sendMessage",[
                "text" => "Результаты поиска:",
                "inline_keyboard" => $buttons
            ]);
        }else{
            return $this->api->execute("sendMessage",[
                "text" => "Извините, ничего не найдено по запросу."
            ]);
        }





        $this->user->search = $text;
        $this->user->action = 0;
        $this->user->save();

        $this->films_list((Object)['data' => [0,true]]);
    }

    public function startSearchSerial($text){
        $this->user->search = $text;
        $this->user->action = 0;
        $this->user->save();

        $this->list((Object)['data' => [0,true]]);
    }

    public function films_list($data){
        $films = kino::where('name', 'LIKE', "%{$this->user->search}%")->orWhere('actors', 'LIKE', "%{$this->user->search}%")->orWhere('genre', 'LIKE', "%{$this->user->search}%")->orderBy('year','desc')->offset($data->data[0]*4)->take(4)->get();
        $count_films = kino::where('name', 'LIKE', "%{$this->user->search}%")->orWhere('actors', 'LIKE', "%{$this->user->search}%")->orWhere('genre', 'LIKE', "%{$this->user->search}%")->count();

        if($count_films==0){
            $this->api->execute('sendMessage',[
                'text'=>"Извините, фильмов по запросу `{$this->user->search}` не найдено.",
            ]);
            return false;
        }

        $count_pages = round($count_films/4);
        $text = "Фильмы по запросу: {$this->user->search}\n\n";
        $f = 1;
        $links = [];
        foreach ($films as $film) {
            $desc = strip_tags($film['description']);
            $desc = mb_substr($desc,0,150);
            $desc = "{$desc}..";
            $film['name'] = str_replace("&nbsp;"," ",$film['name']);

            switch ($f){
                case 1:
                    $text.="1️⃣";
                    $links[] = ['text' => "1️⃣", 'callback_data' => "main:film:search:{$film->id}:0:{$data->data[0]}"];
                    break;
                case 2:
                    $text.="2️⃣";
                    $links[] = ['text' => "2️⃣", 'callback_data' => "main:film:search:{$film->id}:0:{$data->data[0]}"];
                    break;
                case 3:
                    $text.="3️⃣";
                    $links[] = ['text' => "3️⃣", 'callback_data' => "main:film:search:{$film->id}:0:{$data->data[0]}"];
                    break;
                case 4:
                    $text.="4️⃣";
                    $links[] = ['text' => "4️⃣", 'callback_data' => "main:film:search:{$film->id}:0:{$data->data[0]}"];
                    break;
            }

            $text.=" *{$film['name']} ({$film['year']})*";
            $text.="` [imdb:{$film['imdb']}] [kp:{$film['kp']}]`\n";
            $text.="_{$desc}_\n\n";

            $f++;
        }

        $text.="\n🎬 Наш канал - [@smotri_kino_serial](t.me/smotri_kino_serial)";

        $buttons = [];
        $page_str = $data->data[0]+1;
        if($page_str>1){
            $pp = $data->data[0]-1;
            $prev_page = ['text' => "« назад", 'callback_data' => "main:films_list:{$pp}"];
            $buttons[] = $prev_page;
        }
        $curr_page = $data->data[0]+1;
        $buttons[] = ['text' => "[ страница {$curr_page} ]", 'callback_data' => "empty"];
        if($page_str<$count_pages){
            $np = $data->data[0] +1;
            $next_page = ['text' => "вперёд »", 'callback_data' => "main:films_list:{$np}"];
            $buttons[] = $next_page;
        }
        if(!isset($data->message_id)){
            $this->api->execute('sendMessage',[
                'text'=> $text,
                'inline_keyboard' => [$links,$buttons]
            ]);
        }else{
            $this->api->execute('editMessageText', [
                'text'=>$text,
                'message_id'=>$data->message_id,
                'inline_keyboard' => [$links,$buttons]
            ]);
        }

    }

    public function contacts($data){
        $this->api->execute("sendMessage", [
            "text" => "По всем вопросам: @ramm4816"
        ]);
    }

    public function serial($data){
        $serial_id = $data->data[0];
        $serial = serials::where('id',$serial_id)->first();
        $info = json_decode($serial->info);

        foreach ($info as $key => $item) {
            $info->$key = trim($item);
        }


        $caption = "*{$serial->name} ({$info->year})*\n\n";
        $caption .= "❯ Страна: {$info->country}\n";
        $caption .= "❯ Режиссёры: {$info->producer}\n";
        $caption .= "❯ В ролях: {$info->actors}\n";
        $caption .= "❯ Жанр: {$info->genres}\n\n";

        $caption .= "{$info->description}";

        $text_length = mb_strlen($caption);
        if($text_length>1024){
            $caption = mb_substr($caption,0,1021)."...";
        }




        $channels = [
            1 => "-1001437153221",
            2 => "-1001229892759",
            3 => "-1001412376088",
            4 => "-1001167680797",
            5 => "-1001219802857",
        ];


        $this->api->execute('sendPhoto',[
            'token'=>"1308657528:AAEMlKdM8_Tk7HALvOYkIbcpAweuE4LvoOk",
            "chat_id" => $channels[rand(1,5)],
            'photo'=>$info->image,
        ]);

        $res = $this->api->execute("editMessageMedia",[
            "media" => json_encode([
                "type" => "photo",
                "caption" => $caption,
                "parse_mode" => "markdown",
                "media" => $info->image
            ]),
            "message_id" => $data->message_id,
            "inline_keyboard" => [
                [['text' => "△ Начать просмотр","callback_data" => "main:seasons:{$serial_id}"]],
                [['text' => "❮ Назад","callback_data" => "main:list:0"]]
            ]
        ]);
    }

    public function seasons($data){

        $serial_id = $data->data[0];
        $serial = serials::where('id',$serial_id)->first();
        $seasons = json_decode($serial->seasons);




        $buttons = [];


        foreach ($seasons as $season) {
            $buttons[] = [
                ['text' => "Сезон {$season->index}","callback_data"=>"main:episodes:{$serial_id}:{$season->index}"]
            ];
        }
        $buttons[] = [['text' => "❮ Назад","callback_data" => "main:serial:{$serial_id}"]];

        $res = $this->api->execute("editMessageReplyMarkup",[
            "message_id" => $data->message_id,
            "inline_keyboard" => $buttons
        ]);
    }

    public function check_subscribe($data){
        $res = $this->api->execute("getChatMember",[
            "chat_id" => -1001437153221,
            "user_id" => $this->user->chat_id
        ]);

        if($res->ok==true and ($res->result->status=="member" or $res->result->status=="creator" or $res->result->status=="administrator")){
            $this->user->subscribe = 1;
            $this->user->save();
            return $this->api->execute("sendMessage",[
                "text" => "Проверка пройдена, спасибо за подписку."
            ]);
        }else{
            file_put_contents("/var/www/html/filmbot/storage/logs/ggg.json",json_encode($res));
            return $this->api->execute("sendMessage",[
                "text" => "Мы не видим вашу подписку на канал."
            ]);
        }
    }

    public function episodes($data){



        $serial_id = $data->data[0];
        $season_id = $data->data[1]-1;


        $serial = serials::where('id',$serial_id)->first();
        $seasons = json_decode($serial->seasons,true);
        $season = $seasons[$season_id];

        if(isset($data->data[2])){
            $episode_id = $data->data[2]-1;
            $video_id = $season['episodes'][$episode_id]['file_id'];
        }else{
            $episode_id = 0;
            $video_id = $season['episodes'][0]['file_id'];
        }


        $buttons = [];
        $l = 1;

        foreach ($season['episodes'] as $episode) {
            if($l==1){
                $row = [];
            }
            $l++;
            if($episode['index'] == $episode_id+1){
                $text = "❯ {$episode['index']} ❮";
            }else{
                $text = "{$episode['index']}";
            }
            $row[] = [
                "text" => $text,
                "callback_data" => "main:episodes:{$serial_id}:{$data->data[1]}:{$episode['index']}"
            ];
            if($l==6){
                $l=1;
                $buttons[] = $row;
                $row = [];
            }
        }

        if(count($row)>0){
            $buttons[] = $row;
        }
        $buttons[] = [['text' => "❮ Назад","callback_data" => "main:seasons:{$serial_id}"]];

        $this->user->count_actions +=1;
        $this->user->save();

        if($this->user->count_actions>=2 and  $this->user->subscribe==0){
            return $this->api->execute("sendMessage",[
                "text" => "Для того, чтобы продолжить пользоваться ботом, подпишитесь на наш канал 🎬 - [@smotri_kino_serial](t.me/smotri_kino_serial)",
                "inline_keyboard" => [
                    [["text" => "Я подписался","callback_data" => "main:check_subscribe"]]
                ]
            ]);
        }

        $channels = [
            1 => "-1001437153221",
            2 => "-1001229892759",
            3 => "-1001412376088",
            4 => "-1001167680797",
            5 => "-1001219802857",
        ];


        $this->api->execute('sendVideo',[
            'token'=>"1308657528:AAEMlKdM8_Tk7HALvOYkIbcpAweuE4LvoOk",
            "chat_id" => $channels[rand(1,5)],
            'video'=>$video_id,
        ]);


        $res = $this->api->execute("editMessageMedia",[
            "media" => json_encode([
                "type" => "video",
                "parse_mode" => "markdown",
                "caption" => "Серии сезона {$data->data[1]}:",
                "media" => $video_id
            ]),
            "message_id" => $data->message_id,
            "inline_keyboard" => $buttons
        ]);


    }

}
