<?php
namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use App\Models\parser_films;
use Illuminate\Http\Request;


class AdminController extends Controller
{

    public function __construct()
    {

    }

    public function index(){

        $counter = [];
        $serials= parser_films::orderBy('num','desc')->get();
        foreach ($serials as $serial) {
            $counter[$serial->id] = true;
            $seasons = json_decode($serial->json);
            foreach ($seasons as $season) {
                foreach ($season as $episode) {
                    if(!isset($episode->file_id)){
                        $counter[$serial->id] = false;
                    }
                }
            }
        }
        $serial_names = [];
        foreach ($counter as $key => $item) {
            if($item==true){
                $serial= parser_films::where('id',$key)->first();
                $serial_names[] = $serial->name;
            }
        }

        $serials= parser_films::orderBy('num','desc')->get();
        foreach ($serials as $key => $serial) {
            $serials[$key]->seasons = json_decode($serials[$key]->json);
            $serials[$key]->json = null;
        }

        return view('admin.index',['serials' => $serials, 'names'=> $serial_names]);
    }


}



