<?php

namespace App\Console\Commands;

use App\Models\parser_films;
use Illuminate\Console\Command;

class parser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'parse:links';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function getElementValue($string,$strStart,$strEnd){
        $str_search = strpos($string,$strStart);
        if($str_search===false){
            return false;
        }
        $str_1 = substr($string,$str_search+strlen($strStart));
        $str_search = strpos($str_1,$strEnd);
        $res = substr($str_1,0,$str_search);
        return $res;
    }

    public function handle()
    {

        $links = '["/serials/drama/11_22_63/6-1-0-227","/serials/boevik/12_obezjan/2-1-0-187","/serials/detektiv/13_prichin_pochemu/5-1-0-265","/serials/drama/1983/6-1-0-513","/serials/detektiv/4400/5-1-0-38","/serials/boevik/9_1_1/2-1-0-305","/serials/drama/90210/6-1-0-545","/serials/prikljuchencheskij/avanpost/12-1-0-319","/serials/boevik/agent_karter/2-1-0-185","/serials/boevik/agenty_sh_i_t/2-1-0-148","/serials/vestern/ad_na_kolesah/3-1-0-113","/serials/komedija/adam_portit_vse/8-1-0-422","/serials/boevik/akademija_ambrella/2-1-0-491","/serials/boevik/akademija_smerti/2-1-0-466","/serials/detektiv/alienist/5-1-0-296","/serials/boevik/alkatras/2-1-0-115","/serials/biograficheskij/amerikanskaja_istorija_prestuplenij/1-1-0-226","/serials/drama/amerikanskaja_istorija_uzhasov/6-1-0-111","/serials/boevik/amerikanskaja_odisseja/2-1-0-190","/serials/drama/amerikanskaja_semejka/6-1-0-77","/serials/drama/amerikanskie_bogi/6-1-0-269","/serials/detektiv/amerikanskij_vandal/5-1-0-426","/serials/detektiv/amnezija/5-1-0-522","/serials/drama/anatomija_strasti/6-1-0-423","/serials/drama/aromat/6-1-0-486","/serials/boevik/assasiny_vu/2-1-0-546","/serials/drama/atlanta/6-1-0-417","/serials/drama/barri/6-1-0-453","/serials/drama/baskets/6-1-0-367","/serials/detektiv/batl_krik/5-1-0-189","/serials/boevik/beglecy/2-1-0-291","/serials/komedija/bezmozglye/8-1-0-232","/serials/detektiv/belyj_vorotnichok/5-1-0-479","/serials/triller/berlinskaja_rezidentura/14-1-0-428","/serials/boevik/berlinskie_legavye/2-1-0-489","/serials/kriminal/besedy_s_ubijcej_zapisi_teda_bandi/10-1-0-483","/serials/drama/beshenye_psy/6-1-0-536","/serials/boevik/bibliotekari/2-1-0-183","/serials/komedija/blagie_znamenija/8-1-0-525","/serials/drama/blesk/6-1-0-480","/serials/drama/bludlivaja_kalifornija/6-1-0-59","/serials/drama/bludnyj_syn/6-1-0-549","/serials/prikljuchencheskij/boishsja_li_ty_temnoty/12-1-0-568","/serials/drama/bojtes_khodjachikh_mertvecov/6-1-0-202","/serials/drama/bolotnaja_tvar/6-1-0-524","/serials/drama/bolnica_nikerboker/6-1-0-460","/serials/detektiv/bolshaja_malenkaja_lozh/5-1-0-343","/serials/komedija/bolshoj_kush/8-1-0-263","/serials/biograficheskij/bordzhia/1-1-0-105","/serials/drama/bremja_istiny/6-1-0-482","/serials/detektiv/bronzovyj_sad/5-1-0-469","/serials/komedija/bruklin_9_9/8-1-0-350","/serials/drama/bulvarnye_uzhasy_strashnye_skazki/6-1-0-169","/serials/boevik/bumazhnyj_dom/2-1-0-470","/serials/komedija/byvaet_i_khuzhe/8-1-0-471","/serials/detektiv/byt_chelovekom/5-1-0-94","/serials/drama/bjuro_legend/6-1-0-424","/serials/drama/v_luchshem_mire/6-1-0-369","/serials/komedija/v_obezd/8-1-0-353","/serials/boevik/v_pustyne_smerti/2-1-0-213","/serials/komedija/v_filadelfii_vsegda_solnechno/8-1-0-44","/serials/boevik/vavilon_5_serial/2-1-0-27","/serials/boevik/vajnona_ehrp/2-1-0-362","/serials/boevik/van_khelsing/2-1-0-242","/serials/boevik/vedmak/2-1-0-557","/serials/drama/vedmy_ist_ehnda/6-1-0-150","/serials/drama/velikolepnye_medichi/6-1-0-415","/serials/drama/venskaja_krov/6-1-0-567","/serials/biograficheskij/versal/1-1-0-395","/serials/drama/ver/6-1-0-162","/serials/detektiv/vechnost/5-1-0-178","/serials/drama/videt/6-1-0-552","/serials/boevik/vidoizmenennyj_uglerod/2-1-0-297","/serials/boevik/vizitery/2-1-0-81","/serials/boevik/vikingi/2-1-0-136","/serials/biograficheskij/viktorija/1-1-0-476","/serials/drama/vinil/6-1-0-477","/serials/boevik/viski_kavaler/2-1-0-494","/serials/drama/vlast_v_nochnom_gorode/6-1-0-355","/serials/drama/vne_vremeni/6-1-0-244","/serials/komedija/vnutri_devjatogo_nomera/8-1-0-472","/serials/drama/vo_vse_tjazhkie/6-1-0-62","/serials/drama/vo_ploti/6-1-0-137","/serials/drama/vozvrashhenie_domoj/6-1-0-427","/serials/boevik/vozdejstvie/2-1-0-69","/serials/boevik/voin/2-1-0-502","/serials/voennyj/vojna_i_mir/4-1-0-219","/serials/voennyj/vojna_fojla/4-1-0-517","/serials/drama/volshebniki/6-1-0-217","/serials/vestern/vosstanie_tekhasa/3-1-0-194","/serials/drama/vrag_vnutri/6-1-0-498","/serials/biograficheskij/vrazhda/1-1-0-262","/serials/detektiv/vrata/5-1-0-87","/serials/komedija/vse_skhvacheno/8-1-0-377","/serials/drama/vyzhivshie/6-1-0-68","/serials/boevik/nepokornaja_zemlja/2-1-0-139","/serials/drama/germanija_83/6-1-0-538","/serials/boevik/geroi/2-1-0-51","/serials/boevik/geroi_vozrozhdenie/2-1-0-208","/serials/drama/golubaja_krov/6-1-0-409","/serials/detektiv/gorod_gangsterov/5-1-0-154","/serials/drama/gorod_i_gorod/6-1-0-309","/serials/drama/gorod_mechty/6-1-0-120","/serials/drama/gorod_na_kholme/6-1-0-531","/serials/drama/gorod_khishhnic/6-1-0-79","/serials/drama/gosudarstvennyj_sekretar/6-1-0-399","/serials/boevik/gotham/2-1-0-179","/serials/drama/grand_otel/6-1-0-532","/serials/detektiv/greshnica/5-1-0-277","/serials/drama/grezy/6-1-0-320","/serials/detektiv/grimm/5-1-0-112","/serials/drama/grinlif/6-1-0-390","/serials/biograficheskij/gudini/1-1-0-176","/serials/drama/dvojka/6-1-0-374","/serials/detektiv/dekster/5-1-0-52","/serials/detektiv/demony_da_vinchi/5-1-0-140","/serials/drama/detektiv_boskh/6-1-0-475","/serials/detektiv/detektivnoe_agentstvo_dirka_dzhentli/5-1-0-246","/serials/komedija/detstvo_sheldona/8-1-0-361","/serials/boevik/dzhek_rajan/2-1-0-331","/serials/kriminal/dzhekill/10-1-0-57","/serials/boevik/dzhessika_dzhons/2-1-0-214","/serials/drama/dzhonatan_strendzh_i_mister_norrell/6-1-0-193","/serials/kriminal/dikaja_dikaja_strana/10-1-0-431","/serials/boevik/dikij_okrug/2-1-0-490","/serials/drama/dinastija/6-1-0-408","/serials/drama/dnevniki_vampira/6-1-0-75","/serials/drama/doktor_kto/6-1-0-389","/serials/detektiv/doktor_khaus/5-1-0-42","/serials/drama/doktor_khehrrou/6-1-0-437","/serials/drama/dom_s_prislugoj/6-1-0-556","/serials/boevik/dominion/2-1-0-172","/serials/drama/drakula/6-1-0-152","/serials/drama/pervorodnye/6-1-0-149","/serials/drama/drugaja_zhizn/6-1-0-543","/serials/drama/drugoj_vzgljad/6-1-0-512","/serials/drama/druzja_serial/6-1-0-28","/serials/drama/drjan/6-1-0-569","/serials/boevik/zhan_klod_van_dzhonson/2-1-0-238","/serials/boevik/zheleznyj_kulak/2-1-0-264","/serials/boevik/zhivaja_mishen/2-1-0-83","/serials/drama/zhirnym_shriftom/6-1-0-528","/serials/detektiv/za_granju/5-1-0-64","/serials/detektiv/zabytye/5-1-0-76","/serials/vestern/zabytye_bogom/3-1-0-292","/serials/drama/zagadochnye_sobytija_ochen_strannye_dela/6-1-0-237","/serials/vestern/zheleznyj_chelovek/3-1-0-61","/serials/komedija/zakusochnaja_boba/8-1-0-396","/serials/boevik/zalozhnica/2-1-0-261","/serials/drama/zapiski_junogo_vracha/6-1-0-129","/serials/drama/zaterjannye_v_kosmose/6-1-0-310","/serials/boevik/zashhitnik/2-1-0-488","/serials/boevik/zvezdnye_vojny_vojny_klonov/2-1-0-65","/serials/boevik/zvjozdnye_vojny_povstancy/2-1-0-181","/serials/prikljuchencheskij/zvjozdnye_vojny_sily_sudby/12-1-0-273","/serials/prikljuchencheskij/zvjozdnye_vojny_soprotivlenie/12-1-0-382","/serials/boevik/zvezdnye_vrata_atlantida/2-1-0-39","/serials/boevik/zvezdnye_vrata_vselennaja/2-1-0-80","/serials/boevik/zvezdnye_vrata_zv_1/2-1-0-29","/serials/boevik/zvezdnye_vrata_nachalo/2-1-0-298","/serials/boevik/zvezdnyj_krejser_galaktika/2-1-0-43","/serials/boevik/zvezdnyj_put/2-1-0-23","/serials/boevik/zvjozdnyj_put_diskaveri/2-1-0-282","/serials/boevik/zvezdnyj_put_korotkometrazhki/2-1-0-550","/serials/drama/zvjozdnyj_put_pikar/6-1-0-560","/serials/boevik/zvezdnyj_put_ehnterprajz/2-1-0-34","/serials/biograficheskij/zelda_nachalo_vsego/1-1-0-211","/serials/drama/zlo/6-1-0-551","/serials/voennyj/zona_zarazhenija/4-1-0-523","/serials/drama/zybuchij_pesok/6-1-0-529","/serials/detektiv/i_nikogo_ne_stalo/5-1-0-218","/serials/boevik/igra_prestolov_242/2-1-0-103","/serials/drama/igroki/6-1-0-339","/serials/detektiv/izbrannyj/5-1-0-131","/serials/drama/izgoi/6-1-0-97","/serials/drama/izgoj/6-1-0-231","/serials/drama/izumrudnyj_gorod/6-1-0-252","/serials/drama/imperija/6-1-0-352","/serials/boevik/impuls/2-1-0-379","/serials/biograficheskij/imja_mne_noch/1-1-0-481","/serials/boevik/iskusstvennyj_intellekt/2-1-0-155","/serials/detektiv/ispytanie_nevinovnostju/5-1-0-308","/serials/vestern/jelloustoun/3-1-0-316","/serials/drama/kajf_s_dostavkoj/6-1-0-342","/serials/detektiv/kak_izbezhat_nakazanija_za_ubijstvo/5-1-0-370","/serials/boevik/kaprika/2-1-0-84","/serials/boevik/karatel/2-1-0-290","/serials/detektiv/karnival_rou/5-1-0-548","/serials/drama/kartochnyj_domik/6-1-0-413","/serials/detektiv/kasl/5-1-0-71","/serials/drama/kasl_rok/6-1-0-321","/serials/boevik/kastlvanija/2-1-0-449","/serials/boevik/killjoys/2-1-0-199","/serials/biograficheskij/klan_kennedi/1-1-0-100","/serials/biograficheskij/klan_kennedi_posle_kamelota/1-1-0-266","/serials/vestern/klondajk/3-1-0-159","/serials/drama/kljuchi_lokkov/6-1-0-563","/serials/detektiv/kovarnye_gornichnye/5-1-0-142","/serials/drama/kogda_oni_nas_uvidjat/6-1-0-534","/serials/boevik/kolonija/2-1-0-221","/serials/boevik/komendantskij_chas/2-1-0-493","/serials/boevik/kondor/2-1-0-317","/serials/drama/konec_detstva/6-1-0-215","/serials/komiksy/konstantin/9-1-0-306","/serials/mistika/konstantin/11-1-0-182","/serials/boevik/kontinuum/2-1-0-121","/serials/drama/kon_bodzhek/6-1-0-425","/serials/boevik/koroleva_juga_2/2-1-0-335","/serials/istoricheskij/korolevstvo/7-1-0-496","/serials/drama/korporacija/6-1-0-248","/serials/boevik/krajnie_mery/2-1-0-124","/serials/boevik/krajnij_kosmos/2-1-0-539","/serials/detektiv/krasavica_i_chudovishhe/5-1-0-128","/serials/komedija/kremnievaja_dolina/8-1-0-354","/serials/kriminal/krik/10-1-0-201","/serials/boevik/kripton/2-1-0-301","/serials/drama/krovavaja_gonka/6-1-0-271","/serials/komedija/krushenie/8-1-0-373","/serials/detektiv/kult/5-1-0-135","/serials/drama/ladja/6-1-0-537","/serials/boevik/legenda_ob_iskatele/2-1-0-66","/serials/boevik/legendy/2-1-0-166","/serials/boevik/legendy_zavtrashnego_dnja/2-1-0-223","/serials/boevik/legion/2-1-0-258","/serials/drama/ledenjashhie_dushu_prikljuchenija_sabriny/6-1-0-394","/serials/drama/lemoni_sniket_33_neschastja/6-1-0-255","/serials/drama/letjashhie_skvoz_noch/6-1-0-443","/serials/komiksy/lisica_viksen/9-1-0-203","/serials/komedija/loudermilk/8-1-0-407","/serials/drama/luchshe_zvonite_solu/6-1-0-188","/serials/boevik/ljubov_smert_i_roboty/2-1-0-507","/serials/drama/ljudi/6-1-0-197","/serials/boevik/ljudi_alfa/2-1-0-106","/serials/boevik/ljudi_budushhego/2-1-0-151","/serials/boevik/ljuk_kejdzh/2-1-0-243","/serials/detektiv/ljuter/5-1-0-487","/serials/detektiv/ljucifer/5-1-0-224","/serials/boevik/majjancy/2-1-0-332","/serials/drama/makmafija/6-1-0-1","/serials/drama/malenkaja_barabanshhica_8/6-1-0-402","/serials/boevik/mandalorec/2-1-0-555","/serials/detektiv/manifest/5-1-0-368","/serials/drama/manjak/6-1-0-356","/serials/drama/marko_polo/6-1-0-184","/serials/drama/mastera_nauchnoj_fantastiki/6-1-0-58","/serials/drama/matreshka/6-1-0-504","/serials/drama/matotecsyn/6-1-0-497","/serials/detektiv/mgnovenija_grjadushhego_vspomni_chto_budet/5-1-0-78","/serials/drama/mediki_chikago/6-1-0-450","/serials/drama/mertvoe_leto/6-1-0-236","/serials/drama/midnajt_tekhas/6-1-0-276","/serials/drama/mildred_pirs/6-1-0-323","/serials/drama/milliardy/6-1-0-222","/serials/drama/million_melochej/6-1-0-398","/serials/vestern/mir_dikogo_zapada/3-1-0-337","/serials/biograficheskij/missis_uilson/1-1-0-474","/serials/drama/mister_bull/6-1-0-360","/serials/drama/mister_mersedes/6-1-0-278","/serials/drama/mister_robot/6-1-0-200","/serials/komedija/misticheskij_kvest_pir_vorona/8-1-0-564","/serials/drama/molodoj_papa/6-1-0-561","/serials/komedija/monstry_korporacii/8-1-0-447","/serials/detektiv/most/5-1-0-144","/serials/drama/motel_bejtsov/6-1-0-138","/serials/drama/mushketery/6-1-0-158","/serials/detektiv/myslit_kak_prestupnik/5-1-0-349","/serials/komedija/na_grani/8-1-0-478","/serials/drama/na_kraju_vselennoj/6-1-0-30","/serials/komedija/na_rajone/8-1-0-445","/serials/biograficheskij/narko_3/1-1-0-204","/serials/drama/narko_meksika_5/6-1-0-416","/serials/boevik/nasledie/2-1-0-393","/serials/drama/nasledniki/6-1-0-442","/serials/detektiv/nastojashhij_detektiv/5-1-0-344","/serials/boevik/nacija_z/2-1-0-177","/serials/mistika/nevinnye/11-1-0-330","/serials/detektiv/nevinovnyj/5-1-0-419","/serials/mistika/neizvestnye_lica/11-1-0-86","/serials/boevik/neljudi_sverkhljudi/2-1-0-284","/serials/drama/netipichnyj/6-1-0-411","/serials/detektiv/novobranec/5-1-0-392","/serials/drama/novyj_amsterdam/6-1-0-432","/serials/drama/novyj_papa_1/6-1-0-562","/serials/drama/nolnolnol/6-1-0-566","/serials/drama/nosferatu/6-1-0-526","/serials/detektiv/nochnoj_administrator/5-1-0-228","/serials/detektiv/nulevoj_kanal/5-1-0-358","/serials/detektiv/oa/5-1-0-250","/serials/boevik/oblasti_tmy/2-1-0-207","/serials/detektiv/obmani_menja/5-1-0-70","/serials/drama/po_tu_storonu_obratnaja_storona/6-1-0-295","/serials/drama/obshhestvo/6-1-0-519","/serials/boevik/odarennye/2-1-0-286","/serials/drama/odnazhdy_nochju/6-1-0-500","/serials/drama/ozark/6-1-0-275","/serials/drama/omut/6-1-0-311","/serials/drama/oranzhevyj_khit_sezona/6-1-0-380","/serials/drama/orvill/6-1-0-280","/serials/drama/ordinator/6-1-0-385","/serials/boevik/orlinoe_serdce/2-1-0-96","/serials/detektiv/ostavlennye/5-1-0-454","/serials/drama/ostatsja_v_zhivyh/6-1-0-40","/serials/detektiv/ostrov_kharpera/5-1-0-72","/serials/drama/ostrye_kozyrki/6-1-0-145","/serials/detektiv/ostrye_predmety/5-1-0-340","/serials/drama/ot_zakata_do_rassveta/6-1-0-163","/serials/drama/otverzhennye/6-1-0-464","/serials/drama/otkrytie_vedm/6-1-0-386","/serials/detektiv/otchajannye_domokhozjajki/5-1-0-41","/serials/drama/okhotnik_za_razumom/6-1-0-287","/serials/detektiv/okhotniki/5-1-0-565","/serials/detektiv/padajushhaja_voda/5-1-0-366","/serials/detektiv/krah/5-1-0-141","/serials/boevik/padenie_ordena/2-1-0-293","/serials/detektiv/pajn_gehp/5-1-0-509","/serials/boevik/pandora/2-1-0-540","/serials/detektiv/paranormalnyj_vellington/5-1-0-439","/serials/komedija/paranormalshhina_prizraki/8-1-0-285","/serials/drama/park_avenju_666/6-1-0-126","/serials/komedija/propovednik/8-1-0-230","/serials/drama/patrik_melrouz/6-1-0-312","/serials/drama/patriot/6-1-0-260","/serials/boevik/pacany/2-1-0-542","/serials/drama/pacienty/6-1-0-473","/serials/boevik/penniuort/2-1-0-541","/serials/drama/pervye/6-1-0-346","/serials/detektiv/pereval/5-1-0-515","/serials/boevik/perevozchik/2-1-0-130","/serials/drama/pereprava/6-1-0-304","/serials/boevik/pererozhdenie/2-1-0-467","/serials/detektiv/plach/5-1-0-405","/serials/boevik/plashh/2-1-0-93","/serials/boevik/plashh_i_kinzhal/2-1-0-314","/serials/drama/po_volchim_zakonam/6-1-0-233","/serials/komedija/po_druzjam/8-1-0-365","/serials/drama/po_tu_storonu/6-1-0-251","/serials/boevik/pobeg_5_sezon/2-1-0-46","/serials/drama/pobeg_iz_dannemory/6-1-0-421","/serials/voennyj/povorot_agent/4-1-0-165","/serials/detektiv/pod_kupolom/5-1-0-143","/serials/drama/podlyj_pit/6-1-0-254","/serials/boevik/podozrevaemyj/2-1-0-108","/serials/drama/podpolnaja_imperija/6-1-0-391","/serials/drama/pozharnye_chikago/6-1-0-410","/serials/boevik/policija_gavajev/2-1-0-91","/serials/boevik/policija_chikago/2-1-0-448","/serials/drama/polovoe_vospitanie/6-1-0-518","/serials/boevik/poslednee_korolevstvo/2-1-0-209","/serials/boevik/poslednij_korabl/2-1-0-173","/serials/drama/poslednij_magnat/6-1-0-234","/serials/komedija/poslednij_chelovek_na_zemle/8-1-0-347","/serials/detektiv/posledovateli/5-1-0-133","/serials/drama/posrednik/6-1-0-363","/serials/drama/pochemu_zhenshhiny_ubivajut/6-1-0-547","/serials/boevik/pochti_chelovek/2-1-0-153","/serials/drama/predprijatie_vechnaja_blagodat/6-1-0-527","/serials/drama/prizraki_doma_na_kholme/6-1-0-418","/serials/voennyj/prizrachnaja_bashnja/4-1-0-299","/serials/drama/pritvorstvo/6-1-0-503","/serials/drama/pritjazheniju_vopreki/6-1-0-74","/serials/detektiv/probuzhdenie/5-1-0-119","/serials/voennyj/proekt_sinjaja_kniga/4-1-0-465","/serials/fantastika/proiskhozhdenie/16-1-0-429","/serials/vestern/prokljatye/3-1-0-288","/serials/drama/puteshestvennik_vpered_v_proshloe/6-1-0-60","/serials/detektiv/the_path/5-1-0-229","/serials/detektiv/radiovolna/5-1-0-245","/serials/drama/razvod/6-1-0-378","/serials/komedija/razocharovanie/8-1-0-400","/serials/drama/rasskazhi_mne_skazku/6-1-0-403","/serials/drama/rasskaz_sluzhanki/6-1-0-268","/serials/detektiv/rassledovanija_merdoka/5-1-0-401","/serials/komedija/realnye_upyri/8-1-0-499","/serials/drama/rebenok_rozmari/6-1-0-170","/serials/boevik/revoljucija/2-1-0-123","/serials/drama/reka/6-1-0-118","/serials/detektiv/riverdale/5-1-0-257","/serials/komedija/rik_i_morti/8-1-0-372","/serials/boevik/rim/2-1-0-45","/serials/drama/za_predelami/6-1-0-174","/serials/detektiv/rodina/5-1-0-110","/serials/drama/rozhdenie_mafii/6-1-0-198","/serials/drama/rozhdestvenskaja_pesn/6-1-0-558","/serials/boevik/rokovoj_patrul/2-1-0-492","/serials/drama/romanovy/6-1-0-430","/serials/drama/rozuehll_nju_meksiko/6-1-0-468","/serials/drama/rehj_donovan/6-1-0-404","/serials/mistika/salem/11-1-0-168","/serials/detektiv/sverkhestestvennoe_serial/5-1-0-47","/serials/mistika/sverkhestestvennoe_anime/11-1-0-98","/serials/boevik/svetljachok/2-1-0-35","/serials/detektiv/kontakt/5-1-0-117","/serials/komedija/sdelaj_pogromche_charli/8-1-0-514","/serials/detektiv/sekretnye_materialy/5-1-0-26","/serials/drama/sem_sekund/6-1-0-441","/serials/drama/serdce/6-1-0-516","/serials/drama/sirena/6-1-0-318","/serials/boevik/skorpion/2-1-0-348","/serials/drama/slishkom_star_chtoby_umeret_molodym/6-1-0-544","/serials/boevik/slepaja_zona/2-1-0-206","/serials/detektiv/slasher/5-1-0-357","/serials/boevik/smertelnaja_bitva_nasledie/2-1-0-102","/serials/drama/smertelnoe_vlechenie/6-1-0-371","/serials/boevik/smertelnoe_oruzhie/2-1-0-241","/serials/drama/snegopad/6-1-0-383","/serials/drama/soboleznuju_vashej_utrate/6-1-0-433","/serials/drama/sobytie/6-1-0-90","/serials/detektiv/sonnaja_loshhina/5-1-0-146","/serials/boevik/sorvigolova/2-1-0-191","/serials/detektiv/sotnja/5-1-0-164","/serials/boevik/falling_skies/2-1-0-104","/serials/biograficheskij/spartak_bogi_areny/1-1-0-95","/serials/drama/spartak_vojna_prokljatykh/6-1-0-134","/serials/biograficheskij/spartak_krov_i_pesok/1-1-0-85","/serials/drama/spartak_mest/6-1-0-116","/serials/detektiv/spiral/5-1-0-157","/serials/komedija/sploshnoj_otstoj/8-1-0-440","/serials/drama/stalnaja_zvezda/6-1-0-508","/serials/drama/stamptaun/6-1-0-570","/serials/drama/startap/6-1-0-239","/serials/istoricheskij/stolpy_zemli/7-1-0-88","/serials/drama/strana_prilivov/6-1-0-457","/serials/drama/strannyj_angel/6-1-0-315","/serials/boevik/strela/2-1-0-127","/serials/boevik/strelok/2-1-0-247","/serials/komedija/stehn_protiv_sil_zla/8-1-0-414","/serials/boevik/sudnaja_noch/2-1-0-333","/serials/boevik/sumerechnye_okhotniki/2-1-0-384","/serials/boevik/superdevushka/2-1-0-210","/serials/vestern/syn/3-1-0-267","/serials/drama/syny_anarkhii/6-1-0-63","/serials/detektiv/tabu/5-1-0-253","/serials/drama/tajnyj_krug/6-1-0-107","/serials/drama/tajnyj_orden/6-1-0-510","/serials/drama/tvin_piks/6-1-0-25","/serials/drama/telokhranitel/6-1-0-436","/serials/drama/temnaja_materija/6-1-0-196","/serials/prikljuchencheskij/temnye_nachala/12-1-0-553","/serials/komedija/teorija_bolshogo_vzryva/8-1-0-351","/serials/boevik/terminator_bitva_za_budushhee/2-1-0-67","/serials/boevik/terra_nova/2-1-0-109","/serials/drama/terror/6-1-0-303","/serials/boevik/titany/2-1-0-388","/serials/boevik/tikhij_okean/2-1-0-324","/serials/drama/tragedija_v_uehjko/6-1-0-434","/serials/drama/trast/6-1-0-302","/serials/boevik/tredstoun/2-1-0-554","/serials/drama/tretij_glaz_jasnovidec/6-1-0-249","/serials/drama/tuman_mgla/6-1-0-272","/serials/drama/ty_1_sezon/6-1-0-375","/serials/detektiv/tma/5-1-0-535","/serials/voennyj/tjudory/4-1-0-56","/serials/drama/ubivaja_evu_15/6-1-0-313","/serials/drama/ubijstva_po_alfavitu/6-1-0-463","/serials/detektiv/ubijstvo/5-1-0-101","/serials/drama/udivitelnaja_missis_mejzel/6-1-0-501","/serials/drama/uznik_zakljuchennyj/6-1-0-82","/serials/drama/uill/6-1-0-274","/serials/detektiv/uilfred/5-1-0-55","/serials/detektiv/ukushennaja/5-1-0-156","/serials/voennyj/ulovka_22/4-1-0-520","/serials/drama/umiraju_so_smekhu/6-1-0-270","/serials/komedija/upravlenie_gnevom/8-1-0-122","/serials/drama/uspekh/6-1-0-511","/serials/detektiv/utopija/5-1-0-132","/serials/boevik/wayne/2-1-0-484","/serials/detektiv/uehjuord_pajns_sosny/5-1-0-192","/serials/drama/uehntuort/6-1-0-420","/serials/drama/fargo/6-1-0-167","/serials/drama/fart/6-1-0-329","/serials/drama/fleming/6-1-0-161","/serials/boevik/flehsh/2-1-0-180","/serials/biograficheskij/fossi_verdon/1-1-0-505","/serials/drama/fors_mazhory/6-1-0-381","/serials/komedija/futurama/8-1-0-31","/serials/boevik/khanna/2-1-0-495","/serials/detektiv/hitrost/5-1-0-438","/serials/drama/khodjachie_mertvecy/6-1-0-92","/serials/drama/khoroshij_doktor/6-1-0-283","/serials/drama/khoroshij_kop/6-1-0-412","/serials/drama/khoroshie_devchonki/6-1-0-446","/serials/detektiv/khranilishhe_13/5-1-0-73","/serials/detektiv/khroniki_frankenshtejna/5-1-0-212","/serials/prikljuchencheskij/khroniki_shannary/12-1-0-220","/serials/boevik/khehppi/2-1-0-294","/serials/drama/chastnye_syshhiki/6-1-0-376","/serials/komedija/chelovek_budushhego/8-1-0-289","/serials/voennyj/chelovek_v_vysokom_zamke/4-1-0-186","/serials/drama/cherep_i_kosti/6-1-0-171","/serials/drama/chernobyl/6-1-0-521","/serials/boevik/chernaja_molnija/2-1-0-2","/serials/drama/chernoe_zerkalo/6-1-0-114","/serials/boevik/chernoe_leto/2-1-0-506","/serials/komedija/chjornyj_ponedelnik/8-1-0-485","/serials/drama/chernye_parusa/6-1-0-160","/serials/boevik/chjornyj_spisok/2-1-0-147","/serials/boevik/chernyj_spisok_iskuplenie/2-1-0-259","/serials/drama/chi/6-1-0-530","/serials/drama/chuzhaki/6-1-0-225","/serials/drama/chuzhestranka/6-1-0-387","/serials/uzhasy/chuzhoj_antologija/15-1-0-533","/serials/boevik/chuma/2-1-0-444","/serials/detektiv/shakh_i_mat_konec_igry/5-1-0-99","/serials/mistika/shepot/11-1-0-195","/serials/detektiv/sherlok/5-1-0-89","/serials/boevik/shestoj_otrjad/2-1-0-256","/serials/komedija/shitts_krik/8-1-0-359","/serials/drama/shpion/6-1-0-559","/serials/drama/shtamm/6-1-0-175","/serials/drama/shuchu/6-1-0-334","/serials/drama/ehkspansija/6-1-0-216","/serials/drama/ehlita/6-1-0-406","/serials/drama/ehlektricheskie_sny_filipa_k_dika/6-1-0-281","/serials/detektiv/ehlementarno/5-1-0-125","/serials/drama/anne/6-1-0-364","/serials/drama/ehto_my/6-1-0-240","/serials/boevik/ehsh_protiv_zloveshhikh_mertvecov/2-1-0-341","/serials/komedija/juzhnyj_park/8-1-0-397","/serials/drama/jarmarka_tshheslavija/6-1-0-435"]';
        //$links = '["/serials/komedija/adam_portit_vse/8-1-0-422"]';
        $links = json_decode($links,true);

        foreach ($links as $link) {
            echo $link.":::::::::\n\n";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "http://goodserials.tv{$link}");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.83 Safari/537.36',
            ]);
            $res = curl_exec ($ch);

            $serial_name = $this->getElementValue($res, '<title>','</title>');
            $player_link = $this->getElementValue($res, '<meta property="og:video" content="','" />');
            $serial_description = $this->getElementValue($res, '<div class="text-1">','</div>');
            $serial_description = $this->getElementValue($serial_description, 'itemprop="description">','</span>');

            if(empty(explode("playep.pro",$player_link)[1])){
                echo "EMPTY_LINK!\n";
                continue;
            }

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $player_link);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.83 Safari/537.36',
                'Referer: http://goodserials.tv'
            ]);
            $res = curl_exec ($ch);

            $playlist = $this->getElementValue($res,'data-playlist="','"');

            if(empty($playlist)){
                echo "EMPTY_PLAYLIST!\n";
                continue;
            }

            $str = $this->getElementValue($res,'data-voice="','/div>');
            $json = $this->getElementValue($str,'">','<');
            $seasons = json_decode($json);

            $links = [];
            $voice_name = "";

            $optimal_voice = $this->getOptimalVoice($seasons);


            foreach($seasons as $season_key => $season){
                $season_items = [];
                foreach ($season as $episode_key => $episode) {
                    if($optimal_voice!==false){
                        $season_items[] = [
                            'link' => "http://playep.pro/player/responce.php?id={$playlist}&season={$season_key}&episode={$episode_key}&voice={$optimal_voice['voice_id']}",
                            'voice_name' => $optimal_voice['voice_name'],
                            'unique_id' => $this->makeUniqueId()
                        ];
                    }else{
                        $n = 0;
                        foreach ($episode as $key => $voices) {
                            if($n==0){
                                $voice = explode("#",$key);
                                $season_items[] = [
                                    'link' => "http://playep.pro/player/responce.php?id={$playlist}&season={$season_key}&episode={$episode_key}&voice={$voice[0]}",
                                    'voice_name' => $voice[1],
                                    'unique_id' => $this->makeUniqueId()
                                ];
                            }
                            $n++;
                        }
                    }
                }
                $links[] = $season_items;
            }


            $parse_film = new parser_films();
            $parse_film->name = $serial_name;
            $parse_film->description = strip_tags($serial_description);
            $parse_film->json = json_encode($links,JSON_UNESCAPED_UNICODE);
            $parse_film->num = 0;
            $parse_film->save();
         }
    }

    public function getOptimalVoice($seasons){
        $k = 0;
        $first_season_voices = [];
        foreach($seasons as $season_key => $season){
            foreach ($season as $episode_key => $episode) {
                if($k==0){
                    foreach ($episode as $key => $voices) {
                        $first_season_voices[$key] = true;
                    }
                }
                $k++;
            }
        }
        return $this->getVoiceByAllSeries($seasons,$first_season_voices);
    }

    public function getVoiceByAllSeries($seasons,$voices){
        foreach($seasons as $season_key => $season) {
            foreach ($season as $episode_key => $episode) {
                foreach ($voices as $voice_key => $voice) {
                    if(!isset($episode->{$voice_key})){
                        $voices[$voice_key] = false;
                    }
                }
            }
        }
        foreach ($voices as $key => $voice) {
            if($voice == true){
                $voice_id = explode("#",$key)[0];
                $voice_name = explode("#",$key)[1];
                return [
                    'voice_id' => $voice_id,
                    'voice_name' => $voice_name
                ];
            }
        }
        return false;
    }

    public function makeUniqueId(){
        $id = md5(rand(0,9999999999).$this->generateRandomString(10).rand(0,99999999999));
        return $id;
    }

    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

}
