<?php

namespace App\Console\Commands;

use App\Models\parser_films;
use Illuminate\Console\Command;

class downloader extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'downloader:start';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */

    public $films_dir_1 = "/var/www/html/filmbot/storage/films/1/";
    public $films_dir_2 = "/var/www/html/filmbot/storage/films/2/";
    public $films_dir_3 = "/var/www/html/filmbot/storage/films/3/";
    public $current_films_dir = 0;

    public $films_tmp_dir = "/var/www/html/filmbot/storage/films_tmp/";

    public function setDownloaded($unique_id){
        rename("/var/www/html/filmbot/storage/films_tmp/{$unique_id}.mp4", "{$this->current_films_dir}{$unique_id}.mp4");
        $serial = parser_films::where('json','like',"%{$unique_id}%")->first();
        $seasons = json_decode($serial->json,true);
        foreach ($seasons as $season_key => $season) {
            foreach ($season as $episode_key =>  $episode) {
                if($episode['unique_id'] == $unique_id){
                    $seasons[$season_key][$episode_key]['downloaded'] = true;
                    break;
                }
            }
        }
        $serial->json = json_encode($seasons,JSON_UNESCAPED_UNICODE);
        $serial->save();
    }

    public function setSkip($unique_id){
        unlink("/var/www/html/filmbot/storage/films_tmp/{$unique_id}.mp4");
        $serial = parser_films::where('json','like',"%{$unique_id}%")->first();
        $seasons = json_decode($serial->json,true);
        foreach ($seasons as $season_key => $season) {
            foreach ($season as $episode_key =>  $episode) {
                if($episode['unique_id'] == $unique_id){
                    $seasons[$season_key][$episode_key]['skip'] = true;
                    break;
                }
            }
        }
        $serial->json = json_encode($seasons,JSON_UNESCAPED_UNICODE);
        $serial->save();
    }

    public function handle()
    {
        $serials= parser_films::orderBy('num','desc')->get();
        foreach ($serials as $serial) {
            $seasons = json_decode($serial->json);
            foreach ($seasons as $season) {
                foreach ($season as $seria){
                    $count_tmp_files = scandir('/var/www/html/filmbot/storage/films_tmp');
                    if(count($count_tmp_files)-2 >= 20){
                        exit();
                    }

                    $count_files1 = scandir($this->films_dir_1);
                    $count_files2 = scandir($this->films_dir_2);
                    $count_files3 = scandir($this->films_dir_3);

                    if(count($count_files1)-2 < 30) {
                        $this->current_films_dir = $this->films_dir_1;
                    }else if(count($count_files2)-2 < 30){
                        $this->current_films_dir = $this->films_dir_2;
                    }else if(count($count_files3)-2 < 30){
                        $this->current_films_dir = $this->films_dir_3;
                    }else{
                        exit();
                    }


                    if((isset($seria->downloaded) and $seria->downloaded==true) or $seria->skip==true){
                        continue 1;
                    }
                    if(file_exists("{$this->films_tmp_dir}{$seria->unique_id}.mp4")){
                        continue 1;
                    }
                    echo json_encode($seria);
                    $file_link = $this->getQualityLink($seria->link);
                    if(!$file_link){
                        continue 1;
                    }
                    $file_link = $file_link['link'];
                    $command = "ffmpeg -http_persistent false -i '{$file_link}' -threads 20 -c copy -bsf:a aac_adtstoasc '{$this->films_tmp_dir}{$seria->unique_id}.mp4'";
                    exec($command);
                    echo "check downloaded... {$seria->unique_id}\n";
                    $command = "ffprobe -v error -show_entries format=duration -of default=noprint_wrappers=1:nokey=1 '{$this->films_tmp_dir}{$seria->unique_id}.mp4'";
                    $file_duration = exec($command);
                    $parse_duration = $this->getPlaylistDuration($file_link);
                    echo "parse_duration {$parse_duration}";
                    $difference = $file_duration - $parse_duration;
                    echo "difference {$difference}";
                    $difference = $difference < 0 ? $difference * -1 : $difference;
                    if($difference < 70 ) {
                        $this->setDownloaded($seria->unique_id);
                    }else{
                        $this->setSkip($seria->unique_id);
                    }
                    continue 3;
                }
            }
        }

    }

    public function getPlaylistDuration($url){
        $seconds = 0;
        $res = file_get_contents($url);
        $res = explode("\n",$res);
        foreach ($res as $row) {
            if(strpos($row,"EXTINF")!==false){
                $row = explode("EXTINF:",$row);
                $seconds += substr($row[1],0,8);
            }
        }
        return $seconds;
    }

    public function getQualityLink($url){
        $res = json_decode(file_get_contents($url));
        if(!isset($res->src)){
            return false;
        }
        $src_link = $res->src;
        $src_link= str_replace("\r\n","",$src_link);
        $links = [
            '720' => str_replace("index","720/index",$src_link),
            '480' => str_replace("index","480/index",$src_link),
            '360' => str_replace("index","360/index",$src_link),
        ];
        foreach ($links as $key => $link){
            try {
                $res = file_get_contents($link);
                if (strpos($res, "EXTINF") !== false) {
                    return [
                        'quality' => $key,
                        'link' => $link
                    ];
                }
            }catch (\Exception $e){

            }
        }
    }
}
