<?php

namespace App\Console\Commands;

use App\Models\parser_films;
use App\Models\serials;
use Illuminate\Console\Command;

class check_serials extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'check:serials';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $counter = [];
        $serials= parser_films::orderBy('num','desc')->get();
        foreach ($serials as $serial) {
            $counter[$serial->id] = true;
            $seasons = json_decode($serial->json);
            foreach ($seasons as $season) {
                foreach ($season as $episode) {
                    if(!isset($episode->file_id)){
                        $counter[$serial->id] = false;
                    }
                }
            }
        }
        $serial_ids = [];
        foreach ($counter as $key => $item) {
            if($item==true){
                $serial_ids[] = $key;
            }
        }

        foreach ($serial_ids as $serial_id) {
            $this->addSerial($serial_id);
        }

    }

    private function addSerial($id){
        $serial= parser_films::where('id',$id)->first();
        $clear_seasons = [];
        $seasons = json_decode($serial->json);
        $season_index = 0;
        foreach ($seasons as $season) {
            $season_index++;
            $clear_episodes = [];
            $episode_index = 0;
            foreach ($season as $episode) {
                $episode_index++;
                $clear_episodes[] = [
                    'index' => $episode_index,
                    'file_id' => $episode->file_id
                ];
            }
            $clear_seasons[] = [
                'index' => $season_index,
                'episodes' => $clear_episodes
            ];
        }

        $check_serial = serials::where('in_parser_id',$id)->first();
        if(!$check_serial){
            $_serial = new serials();
            $_serial->name = $serial->name;
            $_serial->info = 0;
            $_serial->in_parser_id = $id;
            $_serial->seasons = json_encode($clear_seasons);
            $_serial->save();
        }else{
            $check_serial->seasons = json_encode($clear_seasons);
            $check_serial->save();
        }

    }
}
