<?php

namespace App\TelegramBot;
use App\search_cache;
use App\TelegramBot\Keyboard\BRow;
use App\TelegramBot\Keyboard\Keyboard;
use App\user;

class InlineHandler
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $api;

    public function __construct()
    {

    }

    public function handle($update, $token)
    {
        $inline_id = $update->id;
        $query = $update->query;
        $this->api = new Api(0, $token);


        $search_arr = $this->search($query);

        if($update->offset==""){
            $update->offset = 0;
        }

        $search_arr = array_slice($search_arr, $update->offset, 10);


        $results = [];

        foreach ($search_arr as $key => $audio) {
            $results[] = [
                'type' => 'audio',
                'id' => rand(100000,999999),
                'title' => $audio['title'],
                "audio_url" => $this->api->decodeM3u($audio['url']),
                "audio_duration" =>$audio['duration'],
                "performer" => $audio['artist'],
                "parse_mode" => "markdown",
                "caption" => "Больше музыки [❤ audio_storm_bot️](t.me/audio_storm_bot?start=inlineshare)"
            ];
         }



        $res = $this->api->execute("answerInlineQuery",[
            'inline_query_id' => $inline_id,
            'results' => json_encode($results),
            'next_offset' => $update->offset+10
        ]);

        file_put_contents('/var/www/html/stormbot/storage/logs/test.json',json_encode($res));

    }

    public function search($query){


        $audio_list = search_cache::where('query',$query)->first();
        if(!$audio_list){
            $res = $this->api->vkRequest("audio.getCatalog",[
                "query" => $query,
                "lang" => "ru",
                "https" => 1,
                "ref" => "search",
                "extended" => 0,
                "count" => 200,
                "offset" => 0
            ]);
            if(isset($res->response)){
                $items = $res->response->items;
                $audio_list = [];
                foreach ($items as $item) {
                    if($item->source=="search_global_audios"){
                        $audios = $item->audios;
                        $a=0;
                        foreach ($audios as $audio) {
                            $a++;
                            $audio_list["audio{$a}"] = [
                                'title' => $audio->title,
                                'artist' => $audio->artist,
                                'duration' => $audio->duration,
                                'url' => $audio->url,
                                'identifier' => "{$audio->owner_id}_{$audio->id}"
                            ];
                        }
                        $search_cache = new search_cache();
                        $search_cache->query = $query;
                        $search_cache->songs = json_encode($audio_list,JSON_UNESCAPED_UNICODE);
                        $search_cache->date = time();
                        $search_cache->save();
                    }
                }
            }
        }else{
            $audio_list = json_decode($audio_list->songs,true);
        }

       return $audio_list;

    }

}
