<?php

namespace App\TelegramBot\Handlers;

use App\Models\ads;
use App\Models\audio_playlists;
use App\Models\audio_search_cache;
use App\Models\comments_cache;
use App\Models\flibusta;
use App\Models\library;
use App\Models\serials;
use App\Models\subscriptions;
use App\TelegramBot\Api;
use App\TelegramBot\Keyboard\Keyboard;
use App\TelegramBot\Keyboard\BRow;
use App\Models\user;
use PhpParser\Node\Expr\Cast\Object_;
use CURLFile;

class MainHandler{


    public function __construct($user,$token)
    {
        $this->user = $user;
        $this->api = new Api($user->chat_id,$token);
        $this->defaultMedia = "AgACAgQAAxkDAAInk19tg8IjjdnW0lRQUu3FS6pFCeMOAAKcqzEbOolVU2X1SMc5PHyV16vaJ10AAwEAAwIAA3kAAzipAAIbBA";

        $this->groups = [
            "-1001405410914",
        ];

    }

    public function main(){
        $kb = new Keyboard();
        $kb = $kb->addRow(BRow::createRow()->addButton("📖 Поиск книги",['action'=>'search@book'])->get());
        $kb = $kb->get($this->user);
        $this->api->execute("sendMessage",[
            "text" => "Итак, что хочешь найти?\n\n🚫 Пример плохого запроса - Думой ибоготей или Нополион Х.\n\n✅ Вот пример хорошего запроса - Думай и богатей или Наполеон Хилл\n\nЕсли напишешь название с ошибкой, я тебя не пойму. =\ \nПросто напиши мне в сообщении ниже название книги или имя и фамилию автора.",
            "one_time_keyboard" => "true",
            "keyboard" => $kb,
        ]);
    }

    public function chat(){
        $this->api->execute("sendMessage",[
            "text" => "Наш чат: [Book BOARD ЧАТ](https://t.me/book_board_chat)",
            "inline_keyboard"=> [
                [['text'=> "Перейти в чат","url"=>"https://t.me/book_board_chat"]]
            ]
        ]);
    }

    public function search($data){
        $this->api->execute("sendMessage",[
            "text" => "Введите поисковый запрос:"
        ]);
    }


    public function getBook($data){


        $res = $this->api->execute("getChatMember", [
            'chat_id' => "-1001294552868",
            'user_id' => $this->user->chat_id
        ]);

        if($res->ok == true and ($res->result->status == "member" or $res->result->status == "administrator" or $res->result->status == "creator" or $res->result->status == "restricted" or $res->result->status == "kicked")) {

        } else {
            return $this->api->execute("sendMessage", [
                "text" => "Отличный выбор!\n\n✅ Чтобы пользоваться ботом бесплатно и скачивать книги, сделай одно (но обязательное) действие.\n\nПодпишись на канал с полезными привычками - [52 недели одержимости](https://t.me/kurs_obrazovanie).\n\nПосле подписки нажми еще раз нужную цифру с книгой и, вуа-ля, она скачается =)",
            ]);
        }



        $id = $data->data[0];
        $type = $data->data[1];
        $pdf = $data->data[2];

        $types = [
            "1" => "fb2",
            "2" => "epub",
            "3" => "mobi"
        ];


        if($pdf==0){

            $search_local = library::where('fb_id',$id)->first();
            if($search_local){
                $file_id = $search_local->{$types[$type]};

                $res = $this->api->execute("sendDocument",[
                    "chat_id" => $this->groups[0],
                    "document" => $file_id,
                    "token" => "1342416920:AAFUOJ5MkAC_31PdEpKUB0qYI34rfGFvbAY"
                ]);

                $this->api->execute("sendDocument",[
                    "document" => $file_id,
                    "caption" => "Скачивай и читай, где удобно: от телефона до электронной книги.\n\n😉 _Оставлю ссылку на моего книжного друга, он за 10 минут озвучивает все самое основное из книг и делится этим бесплатно. Подпишись, чтобы не потерять - @ikniga_"
                ]);
            }
        }

    }

    public function book($data){

        $res = $this->api->execute("getChatMember", [
            'chat_id' => "-1001294552868",
            'user_id' => $this->user->chat_id
        ]);

        if($res->ok == true and ($res->result->status == "member" or $res->result->status == "administrator" or $res->result->status == "creator" or $res->result->status == "restricted" or $res->result->status == "kicked")) {

        } else {
            return $this->api->execute("sendMessage", [
                "text" => "Отличный выбор!\n\n✅ Чтобы пользоваться ботом бесплатно и скачивать книги, сделай одно (но обязательное) действие.\n\nПодпишись на канал с полезными привычками - 52 недели одержимости [https://t.me/kurs_obrazovanie](https://t.me/kurs_obrazovanie).\n\nПосле подписки нажми еще раз нужную цифру с книгой и, вуа-ля, она скачается =)",
            ]);
        }


        $identifier = $data->data[1];

        $res = file_get_contents("http://flibusta.site/b/{$identifier}");

        $description = $this->api->getElementValue($res,'<h2>Аннотация</h2>','<hr/>');
        $description = strip_tags($description);
        $description = trim($description);
        $description = str_replace("  "," ",$description);
        $book = flibusta::where('flibusta_id',$identifier)->first();


        $rate = trim($this->api->getElementValue($res,'среднее','</p>'));
        if(empty($rate)){
            $rate = "❔";
        }

        $text = "*Название: {$book->title}*\n*Автор: {$book->first_name} {$book->middle_name} {$book->last_name}*\n*Оценка:* {$rate}\n*Описание:*\n\n{$description}";

        if(mb_strlen($text)>1020){
            $text = mb_substr($text,0,1020)."...";
        }

        $buttons = [];

        if(strpos($res,'(скачать pdf)')!==false){
            $buttons[] = [
                ['text' => "▽ fb2","callback_data" => "main:getBook:{$identifier}:1:1"],
                ['text' => "▽ epub","callback_data" => "main:getBook:{$identifier}:2:1"],
                ['text' => "▽ mobi","callback_data" => "main:getBook:{$identifier}:3:1"]
            ];
        }else{
            $buttons[] = [
                ['text' => "▽ fb2","callback_data" => "main:getBook:{$identifier}:1:0"],
                ['text' => "▽ epub","callback_data" => "main:getBook:{$identifier}:2:0"],
                ['text' => "▽ mobi","callback_data" => "main:getBook:{$identifier}:3:0"]
            ];
        }

        $buttons[] = [['text' => "❮ Назад","callback_data" => "search:bookList:{$data->data[0]}:0"]];

        $this->api->execute("editMessageText", [
            "text" => $text,
            "message_id" => $data->message_id,
            "inline_keyboard" => $buttons
        ]);
    }




}
