<?php

namespace App\TelegramBot\Handlers;

use App\Models\audio_search_cache;
use App\Models\flibusta;
use App\Models\search_cache;
use App\TelegramBot\Api;
use App\TelegramBot\Keyboard\Keyboard;
use App\TelegramBot\Keyboard\BRow;
use PhpParser\Node\Expr\Cast\Object_;

class SearchHandler
{


    public function __construct($user, $token)
    {
        $this->user = $user;
        $this->api = new Api($user->chat_id, $token);
    }

    public function book(){

        $this->api->execute("sendMessage",[
            'text' =>  "Введите поисковый запрос:"
        ]);
    }


    public function searchBook($query){

        if($query=="🎵 Поиск аудиокниги"){
            return $this->abook();
        }
        if($query=="📖 Поиск книги"){
            return $this->book();
        }

        $this->user->action = 0;
        $this->user->save();
        $query = mb_strtolower($query);
        $message_id = $this->api->execute("sendMessage",[
            "text" => "Начинаем поиск.. Пожалуйста, подождите.."
        ])->result->message_id;

        $q = $query;
        $result_arr = [];

        if(strpos($q," ")!==false){
            $q_arr = explode(" ",$q);
        }else{
            $q_arr = [$q];
        }

        $results = flibusta::where('query',"like","%{$q_arr[0]}%")->get();

        foreach ($results as $result) {
            $found = true;
            $result->query = mb_strtolower($result->query);
            foreach ($q_arr as $word) {
                if(strpos($result->query,$word)!==false){
                    $found = true;
                }else{
                    $found = false;
                }
            }

            if($found == true){
                $result_arr[] = $result;
            }
        }

        $exact_math = [];
        $not_exact_math = [];


        $exact_math_count = 0;
        foreach ($result_arr as $item) {
            if(strpos(mb_strtolower($item->title),mb_strtolower($query))!==false){
                $item->title_length = mb_strlen($item->title);
                $exact_math[] = $item;
                $exact_math_count++;
            }else{
                $not_exact_math[] = $item;
            }
        }



        usort($exact_math, function ($a, $b) {
            return $a->title_length - $b->title_length;
        });
        $result_arr = array_merge($exact_math,$not_exact_math);






        $search_cache = new search_cache();
        $search_cache->query = $query;
        $search_cache->books = json_encode($result_arr,JSON_UNESCAPED_UNICODE);
        $search_cache->time = time();
        $search_cache->save();


        $this->bookList((Object)[
           'data' => [
               $search_cache->id,
               0
           ],
            'message_id' => $message_id
        ]);
    }


    public function bookList($data){
        $search_id = $data->data[0];
        $page = $data->data[1];

        $books_list = search_cache::where('id',$search_id)->first();




        $query = $books_list->query;
        $books_list = json_decode($books_list->books,true);
        $books_count = count($books_list);

        $books_list = array_slice($books_list,$page*5,5);

        $prev = $page -1;
        $next = $page +1;
        $button_rows = [];
        $navigate_buttons = [];

        $count_pages = floor($books_count/5);

        $page_str = $page+1;



        if($books_count - $count_pages*5>0){
            $count_pages_str = $count_pages+1;
        }else{
            $count_pages_str = $count_pages;
        }
        // 👇🏻 Страница: {$page_str} из {$count_pages_str}
        $text = "🔍 В поисках: {$query}\n\n";
        $text .= "Вот что мне удалось найти 👇🏻\n\n";

        $i = 0;

        $numbers = ["1️⃣","2️⃣","3️⃣","4️⃣","5️⃣"];
        $select_buttons = [];

        foreach ($books_list as $book) {
            $book['title'] = strip_tags($book['title']);
            $book['title'] = trim(str_replace(["&#039;"],"",$book['title']));
            $book['middle_name'] = trim($book['middle_name']);
            $book['actor'] = trim("{$book['first_name']} {$book['middle_name']} {$book['last_name']}");
            $text .= str_replace("  "," ","{$numbers[$i]} *{$book['title']}* \n`{$book['actor']}`\n\n");
            $select_buttons[] = ["text" => $numbers[$i],"callback_data" => "main:book:{$search_id}:{$book['flibusta_id']}"];
            $i ++;
        }
        $text .= "Подсказка - Для выбора нужной книги нажми соответствующую кнопку с цифрой.\n\n---\n\n🤷‍♂️ Если не знаешь что искать, подпишись на книжный канал с огромнейшим выбором отборной литературы - @ikniga";

        if($page>0){
            $navigate_buttons[] = ['text' => "❮ назад","callback_data" => "search:bookList:{$search_id}:{$prev}"];
        }
        if($page_str < $count_pages_str){
            $navigate_buttons[] = ['text' => "вперёд ❯","callback_data" => "search:bookList:{$search_id}:{$next}"];
        }


        $button_rows[] = $select_buttons;
        $button_rows[] = $navigate_buttons;


        if($books_count!=0){
            $this->api->execute("editMessageText", [
                "text" => $text,
                "message_id" => $data->message_id,
                "inline_keyboard" => $button_rows
            ]);
        }else{
            $this->api->execute("editMessageText", [
                "text" => "🔍 В поисках: \"{$query}\"\n\nУпс... данную книгу не нашёл.\n\nЛибо название/автор написаны неправильно, либо её просто нет.\n\nПопробуй еще раз вбить название, но уже другой книги.\n\n--\n\n🤷‍♂️ Если не знаешь что искать, подпишись на книжный канал с огромнейшим выбором отборной литературы - @ikniga",
                "message_id" => $data->message_id,
                "inline_keyboard" => $button_rows
            ]);
        }


    }



    public function getElementValue($string,$strStart,$strEnd){
        $str_search = strpos($string,$strStart);
        if($str_search===false){
            return false;
        }
        $str_1 = substr($string,$str_search+strlen($strStart));
        $str_search = strpos($str_1,$strEnd);
        $res = substr($str_1,0,$str_search);
        return $res;
    }
}
