<?php
namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use App\Models\parser_films;
use App\Models\users;
use Illuminate\Http\Request;


class AdminController extends Controller
{

    public function __construct()
    {

    }

    public function get_stats(){

        header("Access-Control-Allow-Origin: *");

        $day_time = 60*60*24;

        $count_users = users::count();


        $day_1 = users::where('updated','>',time() - $day_time*1)->count();
        $day_2 = users::where('updated','>',time() - $day_time*2)->count();
        $day_3 = users::where('updated','>',time() - $day_time*3)->count();
        $day_4 = users::where('updated','>',time() - $day_time*4)->count();
        $day_5 = users::where('updated','>',time() - $day_time*5)->count();
        $day_10 = users::where('updated','>',time() - $day_time*10)->count();
        $day_30 = users::where('updated','>',time() - $day_time*30)->count();



        $ref_links = [];
        $unic_refs = users::select('ref')->where('ref','!=','0')->groupBy('ref','id')->distinct()->get();
        foreach ($unic_refs as $unic_ref) {
            $ref_links[] = $unic_ref->ref;
        }



        $ref_stats = [];
        foreach ($ref_links as $unic_ref) {
            if($unic_ref!='0'){
                $count_users_ref = users::where('ref',$unic_ref)->count();
                if($count_users_ref>5){
                    $ref_stats[$count_users_ref] = ['ref'=>$unic_ref,'count'=>$count_users_ref];
                }
            }
        }

        ksort($ref_stats);
        $sort_ref_stats = [];
        foreach ($ref_stats as $ref_stat) {
            $sort_ref_stats[] = $ref_stat;
        }
        $sort_ref_stats = array_reverse($sort_ref_stats);


        return [
            'count_users'=>$count_users,
            'day_1'=>$day_1,
            'day_2'=>$day_2,
            'day_3'=>$day_3,
            'day_4'=>$day_4,
            'day_5'=>$day_5,
            'day_10'=>$day_10,
            'day_30'=>$day_30,
            'ref_stats' => $sort_ref_stats
        ];

    }


    public function get_chart(){

        header("Access-Control-Allow-Origin: *");
        $start_time = strtotime(date("m/d/Y H:00:00"));
        $users_registered = [];
        for($i = 47;$i>=0;$i--){
            $date = date('H:i',$start_time - ($i+1) * 60*60);
            $users_registered[] = [
                'count' => users::where('registered',"<",$start_time - $i * 60*60)->where('registered',">",$start_time - ($i+1) * 60*60)->count(),
                'date' => $date
            ];
        }

        $last_day = users::where('registered',">", time() - 24 * 60 * 60)->count();

        return [
            'chart' => $users_registered,
            'last_day' => $last_day
        ];
    }



    public function ar_chart(){
        $start_time = strtotime(date("m/d/Y H:00:00"));
        $users_registered = [];
        $l=0;
        for($i = 47;$i>=0;$i--){
            $l++;
            $date = date('H:i',$start_time - ($i+1) * 60*60);
            $users_registered[] = users::where('registered',"<",$start_time - $i * 60*60)->where('registered',">",$start_time - ($i+1) * 60*60)->count();
        }

        $max_val = 0;
        foreach ($users_registered as $key => $item) {
            if($item>$max_val){
                $max_val = $item;
            }
        }
        $coeff = $max_val/32;
        foreach ($users_registered as $key => $item) {
            $users_registered[$key] = round(64 -  $item/$coeff);
        }
        $last_day = users::where('registered',">", time() - 24 * 60 * 60)->count();
        $all_users = users::count();
        return [
            "data" => $users_registered,
            'last_day' => $last_day,
            "all_users" => $all_users
        ];
    }

}



