<?php

namespace App\TelegramBot\Keyboard;

class BRowFactory{

    private $row;

    public function addButton($text,$payload){
        $action = [];
        $action['text'] = $text;
        $action['payload'] = $payload;

        $this->row[] = $action;
        return $this;
    }

    public function addInlineButton($text,$callback,$payload){
        $action = [];
        $action['text'] = $text;
        $action['callback_data'] = $callback;
        $action['payload'] = $payload;
        $this->row[] = $action;
        return $this;
    }

    public function get(){
        return $this->row;
    }

    public function microtime_float()
    {
        list($usec, $sec) = explode(" ", microtime());
        return ((float)$usec + (float)$sec);
    }
}
