<?php

namespace App\TelegramBot\Handlers;

use App\Models\audio_parts;
use App\Models\flibusta;
use App\Models\flibusta_catalog;
use App\Models\library;
use App\Models\search_cache;
use App\TelegramBot\Api;
use App\TelegramBot\Keyboard\Keyboard;
use App\TelegramBot\Keyboard\BRow;
use GuzzleHttp\Client;
use PhpParser\Node\Expr\Cast\Object_;

class MainHandler{


    public function __construct($user,$token)
    {
        $this->user = $user;
        $this->api = new Api($user->chat_id,$token);
        $this->defaultMedia = "AgACAgQAAxkDAAInk19tg8IjjdnW0lRQUu3FS6pFCeMOAAKcqzEbOolVU2X1SMc5PHyV16vaJ10AAwEAAwIAA3kAAzipAAIbBA";
        $this->channels = [
            //"-1001167188175", //книга на милл
            "-1001183088287", //americos
            "-1001265138340", //study board
            "-1001359938865", //elonnew
        ];
    }

    public function main(){
        $kb = new Keyboard();
        $kb = $kb->addRow(BRow::createRow()->addButton("📖 Поиск книги",['action'=>'main@search_button'])->get());
        //$kb = $kb->addRow(BRow::createRow()->addButton("Очистить кеш",['action'=>'main@clear_cache'])->get());
        $kb = $kb->get($this->user);


        $this->check_subscribe(false);

        $this->api->execute("sendMessage",[
            "text" => "Привет 😊\n\nЯ найду для тебя любую книгу в библиотеке Флибусты, а так же аудиокниги из большой базы.",
            "keyboard" => $kb
        ]);
    }

    public function check_subscribe($params){
        foreach ($this->channels as $channel) {
            $res = $this->api->execute("getChatMember", [
                'chat_id' => $channel,
                'user_id' => $this->user->chat_id
            ]);
            if($res->ok == true and ($res->result->status == "member" or $res->result->status == "administrator" or $res->result->status == "creator" or $res->result->status == "restricted" or $res->result->status == "kicked")) {
            } else {
                /*
                $this->api->execute("sendMessage",[
                    "text" => "`".json_encode($res)."`".$channel
                ]);
                */

                $this->api->execute("sendMessage", [
                    "text" => "[✅](https://telegra.ph/file/ef1d1be7d1201945252cf.png) Чтобы пользоваться ботом бесплатно и скачивать книги, сделай одно (но обязательное) действие.\n\nПодпишись на три канала:\n\n"
                        ."[@Study_BOARD](https://t.me/Study_BOARD)\n"
                        ."[@Americocos](https://t.me/Americocos)\n"
                        ."[@elonnew](https://t.me/joinchat/QGShZQQsW6VjYjMy)\n"
                        //."[Книги на миллион](https://t.me/joinchat/fZREqXbOm1UyMjky)\n\n"
                        ."После подписки нажми еще раз нужную цифру с книгой и, вуа-ля, она скачается =)",
                    "disable_web_page_preview" => false,
                    "inline_keyboard" => [
                        [['text' => "Подписаться на канал №1", "url" => "https://t.me/Study_BOARD"]],
                        [['text' => "Подписаться на канал №2", "url" => "https://t.me/Americocos"]],
                        [['text' => "Подписаться на канал №3", "url" => "https://t.me/joinchat/QGShZQQsW6VjYjMy"]],
                       // [['text' => "Подписаться на канал №3", "url" => "https://t.me/joinchat/fZREqXbOm1UyMjky"]],
                        [["text" => "Проверить подписку", "callback_data" => "main:check_subscribe"]]
                    ]
                ]);
                exit();
            }
        }
        if($params!=false and isset($params['message_id'])){
            $this->api->execute("editMessageText",[
                "message_id" => $params['message_id'],
                "text" => "Проверка на подписку пройдена."
            ]);
        };
    }

    public function clear_cache(){
        $cache = search_cache::get();

        foreach ($cache as $item) {
            $item->delete();
        }

        $this->api->execute("sendMessage",[
            "text" => 'Cache cleared.'
        ]);
    }

    public function chat(){
        $this->api->execute("sendMessage",[
            "text" => "Наш чат: [Book BOARD ЧАТ](https://t.me/book_board_chat)",
            "inline_keyboard"=> [
                [['text'=> "Перейти в чат","url"=>"https://t.me/book_board_chat"]]
            ]
        ]);
    }

    public function search_button($data){
        $this->api->execute("sendMessage",[
            "text" => "🔎 Введите поисковый запрос:"
        ]);
    }

    public function fBookGet($params){
        $this->check_subscribe(false);

        $this->api->execute("editMessageText",[
            "text" => "Пожалуйста, подождите, мы уже готовим для вас книгу 😊\n\n_Это может занять от нескольких секунд до минут._",
            "message_id" => $params['message_id']
        ]);
        $data = $params['data'];


        $library_search = library::where('fb_id',$data[0])->first();
        if($library_search){
            $file_id = $library_search->{$data[1]};

            $this->api->execute("sendDocument",[
                "chat_id" => "-1001413063944",
                "document" => $file_id,
                "token" => "1342416920:AAFUOJ5MkAC_31PdEpKUB0qYI34rfGFvbAY"
            ]);

            $res = $this->api->execute("sendDocument",[
                "document" => $file_id,
                'caption' => '[@Knigavsluh_bot](t.me/Knigavsluh_bot?start=share)'
            ]);

            if($res->ok==true){
                return true;
            }
        }




        $client = new Client();
        $search_request = $client->request('GET', "https://tgram.online/api/books.get", [
            'query' => [
                'fb_id' => $data[0],
                'callback' => json_encode([
                    'url' => 'https://knigavsluh.teleadmin.ru/api_books_callback',
                    'data' => [
                        'chat_id' => $this->user->chat_id,
                        'type' => $data[1]
                    ]
                ])
            ]
        ]);
        $result_json = $search_request->getBody();
        $result = json_decode($result_json);
        if($result->book){
            $this->api->execute("sendDocument",[
                "document" => $result->book->{$data[1]},
                'caption' => '[@Knigavsluh_bot](t.me/Knigavsluh_bot?start=share)'
            ]);
        }
    }

    public function aBook($id){
        $this->api->execute("sendMessage",[
            "text" => "Пожалуйста, подождите, мы уже готовим для вас книгу 😊",
        ]);

        $client = new Client();
        $search_request = $client->request('GET', "https://tgram.online/api/books.get", [
            'query' => [
                'id' => $id
            ]
        ]);
        $result_json = $search_request->getBody();
        $result = json_decode($result_json);




        $audio_parts = audio_parts::where('audio_book_id',$id)->first();
        if(!$audio_parts){

            $audio_parts = new audio_parts();
            $audio_parts->audio_book_id = $id;
            $audio_parts->parts = json_encode($result->parts);
            $audio_parts->save();
        }


        $message = "*{$result->book->title} - {$result->book->authors}*\n\n";
        $message .= "Озвучка: {$result->book->reader}\n";
        $message .= "{$result->book->description}";

        $this->api->execute("sendMessage",[
            "text" => $message,
            "inline_keyboard" => [
                [['text' => "Слушать","callback_data" => "main:aBookListen:{$id}:0"]]
            ]
        ]);
    }

    public function aBookListen($params){

        $this->check_subscribe(false);

        $page = $params['data'][1];
        $next_page = $page+1;

        $audio_parts = audio_parts::where('audio_book_id',$params['data'][0])->first();

        $audio_tokens = [
            1 => '1625982191:AAFdoGMJuR8jLd2703PZiCwuTudmhHAs6c8',
            2 => '1689450104:AAEPOKPbK-ZXb7ynF6eR8eA9nYymngCUzdw',
            3 => '1601563235:AAHDtb-0YCDW6Qq_59H41Y5mQKu4pIb5nVQ',
            4 => '1699170696:AAGotakurh4wNBt72gw33lTDKvKkXBAle54',
            5 => '1618242776:AAEKr0j1N4yqja60MGT8jTgytec6Rh7gPFg',
            6 => '1602572486:AAFqM39M0XGCM6-jawpyTcDoy6ZwQ_G4ZSw',
            7 => '1634081195:AAHknjF3dV1-3yvBi6BEQCQTSSQyMNkHeTE',
            8 => '1578079672:AAG2NGzp3miIwfJtyBjZpwcT2bb9BJZRgsw'
        ];

        $audio_parts = json_decode($audio_parts->parts,true);
        $audio_parts_count = count($audio_parts);

        $l = 0;

        foreach ($audio_parts as $audio_part) {
            $l++;
            $is_last = $l >= $audio_parts_count ? true : false;
            if($l > $page * 5 and $l <= $page * 5 + 5){
                $res = $this->api->execute("sendAudio",[
                    'audio' => $audio_part['file_id'],
                    'caption' => '[@goodlib_bot](t.me/goodlib_bot?start=share)',
                    'inline_keyboard' => (($l == count($audio_parts) or $l == $page*5 + 5) and !$is_last) ? [
                        [[
                            'text' => "Слушать далее ❯",
                            'callback_data' => "main:aBookListen:{$params['data'][0]}:". $next_page
                        ]]
                    ] : 0
                ]);
                if($res->ok==false){


                    $res = $this->api->execute("sendAudio",[
                        "chat_id" => "-1001413063944",
                        "token" => $audio_tokens[$audio_part['bot']],
                        'audio' => $audio_part['file_id'],
                    ]);

                    $this->api->execute("sendAudio",[
                        'audio' => $audio_part['file_id'],
                        'caption' => '[@goodlib_bot](t.me/goodlib_bot?start=share)',
                        'inline_keyboard' => (($l == count($audio_parts) or $l == $page*5 + 5) and !$is_last) ? [
                            [[
                                'text' => "Слушать далее ❯",
                                'callback_data' => "main:aBookListen:{$params['data'][0]}:". $next_page
                            ]]
                        ] : 0
                    ]);
                }
            }

        }

    }

    public function fBook($id){


        $book = flibusta_catalog::where('flibusta_id',$id)->first();

        $this->api->execute("sendMessage",[
            "text" => "<b>{$book->first_name} {$book->middle_name} {$book->last_name} - {$book->title}</b>",
            "inline_keyboard" => [
                [
                    ['text' => 'fb2','callback_data' => "main:fBookGet:{$id}:fb2"],
                    ['text' => 'epub','callback_data' => "main:fBookGet:{$id}:epub"],
                    ['text' => 'mobi','callback_data' => "main:fBookGet:{$id}:mobi"]
                ]
            ],
            'parse_mode' => 'html'
        ]);


    }

    public function search($text){

        $message_id = $this->api->execute("sendMessage",[
            "text" => "🔎 Ожидайте, идёт поиск.."
        ])->result->message_id;


        $search_cache = search_cache::where('query',$text)->first();


        if($search_cache){
            return $this->select_type([
                'data' => [$search_cache->id],
                'message_id' => $message_id
            ]);
        }



        $client = new Client();
        $search_request = $client->request('GET', "https://tgram.online/api/books.search", [
            'query' => [
                'type' => 'all',
                'q' => $text
            ]
        ]);
        $result_json = $search_request->getBody();
        $result = json_decode($result_json);

        if(count($result->text_list)==0 and count($result->audio_list)==0){
            return $this->api->execute("editMessageText",[
                "message_id" => $message_id,
                "text" => "По вашему запросу не найдено книг."
            ]);
        }




        $search_cache = new search_cache();
        $search_cache->query = $text;
        $search_cache->books = json_encode($result);
        $search_cache->time = time();
        $search_cache->save();

        $this->select_type([
            'data' => [$search_cache->id],
            'message_id' => $message_id
        ]);

    }


    public function select_type($params){
        $data = $params['data'];
        $message_id = $params['message_id'];
        $cache_id = $data[0];

        $cache = search_cache::where('id',$cache_id)->first();


        if(!$cache){
            return $this->api->execute('editMessageText',[
                'text' => 'Извините, поисковая выдача устарела, повторите попытку.',
                'message_id' => $message_id
            ]);
        }
        $result = json_decode($cache->books,true);





        $count_books = count($result['text_list']);
        $count_audio_books = count($result['audio_list']);

        $buttons = [];

        if($count_books>0){
            $word = $this->format_by_count($count_books,"Книга","Книги","Книг");
            $buttons[] = [[
                "text" => "📖 {$count_books} {$word}","callback_data" => "main:list:{$cache_id}:text_list:0"
            ]];
        }
        if($count_audio_books>0){
            $word = $this->format_by_count($count_audio_books,"Книга","Книги","Книг");
            $buttons[] = [[
                "text" => "🎵 {$count_audio_books} Аудио {$word}","callback_data" => "main:list:{$cache_id}:audio_list:0"
            ]];
        }


        return $this->api->execute('editMessageText',[
            'text' => "По вашему запросу \"{$cache->query}\" найдено:",
            "inline_keyboard" => $buttons,
            'message_id' => $message_id
        ]);

    }

    public function format_by_count($count, $form1, $form2, $form3)
    {
        $count = abs($count) % 100;
        $lcount = $count % 10;
        if ($count >= 11 && $count <= 19) return($form3);
        if ($lcount >= 2 && $lcount <= 4) return($form2);
        if ($lcount == 1) return($form1);
        return $form3;
    }

    public function list($params){
        $data = $params['data'];
        $message_id = $params['message_id'];

        $cache_id = $data[0];
        $type = $data[1];
        $page = $data[2];

        $cache = search_cache::where('id',$cache_id)->first();
        if(!$cache){
            return $this->api->execute('editMessageText',[
                'text' => 'Извините, поисковая выдача устарела, повторите попытку.',
                'message_id' => $message_id
            ]);
        }

        $books = json_decode($cache->books,true);

        $books = $books[$type];


        $count_books = count($books);
        $count_pages = ceil($count_books/8);
        $books = array_slice($books,$page*8, 8);


        $message = "🔍 Поиск по запросу: \"{$cache->query}\":\n\n";

        foreach ($books as $book) {
            if(isset($book['flibusta_id'])){
                $message .= "📖 /f_{$book['flibusta_id']} <b>{$book['title']}</b> - {$book['first_name']} {$book['middle_name']} {$book['last_name']}\n\n";
            }else{
                $message .= "🎵 /a_{$book['id']} <b>{$book['title']}</b> - {$book['authors']}\n\n";
            }
        }

        $message.="___________________________\n\n<a href='https://t.me/TranslateBot?start=Knigavsluh_bot'>@TRANSLATEBOT</a> — переводит прямо в Телеграм, даже сложные и длинные предложения!";

        $controls = [];

        if($page>0){
            $controls[] = [
                'text' => "Назад",
                "callback_data" => "main:list:{$cache_id}:{$type}:".($page-1)
            ];
        }
        $controls[] = [
            'text' => "Страница ".($page+1)." / {$count_pages}",
            "callback_data" => "currpage"
        ];
        if($page < $count_pages-1){
            $controls[] = [
                'text' => "Вперёд",
                "callback_data" => "main:list:{$cache_id}:{$type}:".($page+1)
            ];
        }

        $this->api->execute('editMessageText',[
            'text' => $message,
            'message_id' => $message_id,
            'parse_mode' => 'html',
            'inline_keyboard' => [$controls]
        ]);





    }


}
