<?php

namespace App\TelegramBot;

use App\Models\users;
use App\TelegramBot\Handlers\MainHandler;
use App\TelegramBot\Handlers\SearchHandler;
use PhpParser\Node\Expr\Cast\Object_;

class MessagesHandler
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $api;

    public function __construct()
    {

    }

    public function handle($update,$token)
    {
        $chat_id = $update->from->id;
        if($chat_id != $update->chat->id){
            return false;
        }

        /*
        if($update->from->id!=1250349080 and $update->from->id!=383053151 and $update->from->id!=253027761 and $update->from->id!=207933200){
            $this->api = new Api($update->from->id, $token);
            $this->api->execute("sendMessage",[
                "text" => "Ведутся работы по обновлению и улучшению работы бота. Спасибо за понимание.\n\nРаботы закончатся примерно через 30 минут."
            ]);
            exit();
        }
        */

        $first_name = !empty($update->from->first_name) ? $update->from->first_name : "";
        $username = !empty($update->from->username) ? $update->from->username : "";

        $user = users::where('chat_id', $chat_id)->first();

        if(!$user){
            $user = $this->createUserTables($chat_id,$first_name,$username);
            $this->api = new Api($update->from->id, $token);
            if (strpos($update->text, "/start") !== false) {
                $ref = explode(" ",$update->text);
                if(isset($ref[1])){
                    $user->ref = $ref[1];
                    $user->save();
                }
            }
        }else{
            $user->updated = time();
            $user->save();
            $this->api = new Api($update->from->id, $token);
        }

        if (!isset($update->text)) {
            exit();
        }

        if ($user->action != "0") {
            $action = json_decode($user->action);
            $data = !empty($action->data) ? $action->data : 0;
            $action = $action->action;
            $action = explode("@", $action);
            $action[0] = "App\TelegramBot\Handlers\\" . ucfirst($action[0]) . "Handler";
            $handler = new $action[0]($user, $token);
            return $handler->{$action[1]}($update->text, $data);
        }

        if($user->keyboard_actions != "0") {
            $keyboard_actions = json_decode($user->keyboard_actions);
            if(isset($keyboard_actions->bottom)){
                $keyboard_actions = $keyboard_actions->bottom;
                if (isset($keyboard_actions->{$update->text})) {
                    $action = $keyboard_actions->{$update->text}->action;
                    $action = explode("@", $action);
                    $action[0] = "App\TelegramBot\Handlers\\" . ucfirst($action[0]) . "Handler";
                    $handler = new $action[0]($user, $token);
                    $data = !empty($keyboard_actions->{$update->text}->data) ? $keyboard_actions->{$update->text}->data : false;
                    return $handler->{$action[1]}($data);
                }
            }
        }

        if(strpos($update->text, "/start") !== false or $user->keyboard_actions=="0"){
            $handler = new MainHandler($user, $token);
            return $handler->main();
        }else if(strpos($update->text,'/f_')!==false){
            $fb_id = explode("_",$update->text)[1];
            $handler = new MainHandler($user, $token);
            return $handler->fBook($fb_id);
        }else if(strpos($update->text,'/a_')!==false){
            $a_id = explode("_",$update->text)[1];
            $handler = new MainHandler($user, $token);
            return $handler->aBook($a_id);
        }else{
            $handler = new MainHandler($user, $token);
            return $handler->search($update->text);
        }
    }




    private function createUserTables($chat_id,$first_name,$username){
        $user = new users();
        $user->chat_id = $chat_id;
        $user->username = $username;
        $user->first_name = $first_name;
        $user->ref = "";
        $user->search = "";
        $user->action = "0";
        $user->keyboard_actions = "0";
        $user->updated = 0;
        $user->registered = time();
        $user->save();

        return $user;
    }


}
