<?php

namespace App\TelegramBot\Handlers;

use App\Models\ads;
use App\Models\audio_parts;
use App\Models\flibusta;
use App\Models\flibusta_catalog;
use App\Models\library;
use App\Models\search_cache;
use App\Models\subscriptions;
use App\TelegramBot\Api;
use App\TelegramBot\Keyboard\Keyboard;
use App\TelegramBot\Keyboard\BRow;
use GuzzleHttp\Client;
use PhpParser\Node\Expr\Cast\Object_;

class MainHandler{


    public function __construct($user,$token)
    {
        $this->user = $user;
        $this->api = new Api($user->chat_id,$token);
        $this->groups = [
            "-1001361950663",
            "-1001205903044",
            "-1001408637102",
            "-1001338911760",
            "-1001483902189",

            "-1001434366235",
            "-1001383094530",
            "-1001465697118",
            "-1001463379102",
            "-1001187276689",

            "-1001202532547",
            "-1001286731259",
            "-1001440578314",
            "-1001359574365",
            "-1001410799834",

            "-1001247332959",
            "-1001195485059",
            "-1001484982783",
            "-1001437025869",
            "-1001492414282",
        ];
        $this->fbooks_tokens = [
            'A' => '1689364775:AAGQj3637HoPxOKXVDFa3YCGFeGuY4aUVHc',
            'B' => '1526680506:AAGuoqu75Dji70IuHoJK6a8ZQ8-ZaP_iyjw',
            'C' => '1696597178:AAFyLhnjMjYLYFeZVwQ2ov9-1vXRUNwojnM',
            'D' => '1674544943:AAFvCMdTEH-WvpGItSYQkcEsv65M6Tt_EZ8',
            'E' => '1696161987:AAHmp56GBlgEuIprhHhWmwIdVSwv1y_5Dkg',
            'F' => '1679973209:AAFe-DsFYdyqpjHyKuLz6uwdbwwDI_GNkt0'
        ];
    }

    public function main(){
        $kb = new Keyboard();
        $kb = $kb->addRow(BRow::createRow()->addButton("📖 Поиск книги",['action'=>'main@search_button'])->get());
        //$kb = $kb->addRow(BRow::createRow()->addButton("Очистить кеш",['action'=>'main@clear_cache'])->get());
        $kb = $kb->get($this->user);




        foreach (["-1001265138340","-1001493534464","-1001264980224"] as $channel) {
            $res = $this->api->execute("getChatMember", [
                'chat_id' => $channel,
                'user_id' => $this->user->chat_id
            ]);
            if($res->ok == true and ($res->result->status == "member" or $res->result->status == "administrator" or $res->result->status == "creator" or $res->result->status == "restricted" or $res->result->status == "kicked")) {
            } else {
                return $this->api->execute("sendMessage", [
                    "text" => "Отличный выбор![⠀](https://telegra.ph/file/ef1d1be7d1201945252cf.png)\n\n"
                        ."✅ Чтобы пользоваться ботом бесплатно и скачивать книги, сделай одно (но обязательное) действие.\n\n"
                        ."Подпишись на 3 канала: \n\n"
                        ."[@Study_BOARD](https://t.me/Study_BOARD)\n"
                        ."[Аудиокниги каждый день 📚](https://t.me/audioknigi_everyday)\n"
                        ."[@knizhnikc](https://t.me/knizhnikc)\n\n"
                        ."После подписки нажми еще раз нужную цифру с книгой и, вуа-ля, она скачается =)",
                    "disable_web_page_preview" => false,
                    "inline_keyboard" => [
                        [['text' => "Подписаться на канал №1", "url" => "https://t.me/Study_BOARD"]],
                        [['text' => "Подписаться на канал №2", "url" => "https://t.me/audioknigi_everyday"]],
                        [['text' => "Подписаться на канал №3", "url" => "https://t.me/knizhnikc"]],
                        [["text" => "Проверить подписку", "callback_data" => "main:check_subscribe"]]
                    ]
                ]);
            }
        }

        $this->api->execute("sendMessage",[
            "text" => "Привет 😊\n\nЯ найду для тебя любую книгу в библиотеке Флибусты, а так же аудиокниги из большой базы.",
            "keyboard" => $kb
        ]);
    }


    public function check_subscribe($params){

        foreach (["-1001265138340","-1001493534464","-1001264980224"] as $channel) {
$res = $this->api->execute("getChatMember", [
                'chat_id' => $channel,
                'user_id' => $this->user->chat_id
            ]);
            if($res->ok == true and ($res->result->status == "member" or $res->result->status == "administrator" or $res->result->status == "creator" or $res->result->status == "restricted" or $res->result->status == "kicked")) {
            }else{
                return $this->api->execute("answerCallbackQuery",[
                    "callback_query_id" => $params['callback_id'],
                    "text" => "Вы не подписались на канал!"
                ]);
            }
        }
        $this->api->execute("deleteMessage",[
            "message_id" => $params['message_id']
        ]);
        $this->api->execute("sendMessage",[
            "text" => "Проверка на подписку пройдена, спасибо. Ты супер 😗\n\nЕще раз нажми на кнопку выше, чтобы получить книгу."
        ]);

    }
    public function clear_cache(){
        $cache = search_cache::get();

        foreach ($cache as $item) {
            $item->delete();
        }

        $this->api->execute("sendMessage",[
            "text" => 'Cache cleared.'
        ]);
    }

    public function chat(){
        $this->api->execute("sendMessage",[
            "text" => "Наш чат: [Book BOARD ЧАТ](https://t.me/book_board_chat)",
            "inline_keyboard"=> [
                [['text'=> "Перейти в чат","url"=>"https://t.me/book_board_chat"]]
            ]
        ]);
    }

    public function search_button($data){
        $this->api->execute("sendMessage",[
            "text" => "🔎 Введите поисковый запрос:"
        ]);
    }

    public function fBookGet($params){
        foreach (["-1001265138340","-1001493534464","-1001264980224"] as $channel) {
$res = $this->api->execute("getChatMember", [
                'chat_id' => $channel,
                'user_id' => $this->user->chat_id
            ]);
            if($res->ok == true and ($res->result->status == "member" or $res->result->status == "administrator" or $res->result->status == "creator" or $res->result->status == "restricted" or $res->result->status == "kicked")) {
            } else {
                return $this->api->execute("sendMessage", [
                    "text" => "Отличный выбор![⠀](https://telegra.ph/file/ef1d1be7d1201945252cf.png)\n\n"
                        ."✅ Чтобы пользоваться ботом бесплатно и скачивать книги, сделай одно (но обязательное) действие.\n\n"
                        ."Подпишись на 3 канала: \n\n"
                        ."[@Study_BOARD](https://t.me/Study_BOARD)\n"
                        ."[Аудиокниги каждый день 📚](https://t.me/audioknigi_everyday)\n"
                        ."[@knizhnikc](https://t.me/knizhnikc)\n\n"
                        ."После подписки нажми еще раз нужную цифру с книгой и, вуа-ля, она скачается =)",
                    "disable_web_page_preview" => false,
                    "inline_keyboard" => [
                        [['text' => "Подписаться на канал №1", "url" => "https://t.me/Study_BOARD"]],
                        [['text' => "Подписаться на канал №2", "url" => "https://t.me/audioknigi_everyday"]],
                        [['text' => "Подписаться на канал №3", "url" => "https://t.me/knizhnikc"]],
                        [["text" => "Проверить подписку", "callback_data" => "main:check_subscribe"]]
                    ]
                ]);
            }
        }

        $this->api->execute("editMessageText",[
            "text" => "Пожалуйста, подождите, мы уже готовим для вас книгу 😊\n\n_Это может занять от нескольких секунд до минут._",
            "message_id" => $params['message_id']
        ]);
        $data = $params['data'];


        $library_search = library::where('fb_id',$data[0])->first();
        if($library_search){

            $file_id = $library_search->{$data[1]};

            $this->api->execute("sendDocument",[
                "chat_id" => $this->groups[rand(0,19)],
                "document" => $file_id,
                "token" => "1342416920:AAFUOJ5MkAC_31PdEpKUB0qYI34rfGFvbAY"
            ]);

            $res = $this->api->execute("sendDocument",[
                "document" => $file_id,
                'caption' => '[@goodlib_bot](t.me/goodlib_bot?start=share)'
            ]);

            if($res->ok==true){

                $ads = ads::where('count','>',0)->get();

                foreach ($ads as $ad){
                    $check = subscriptions::where('chat_id',$this->user->chat_id)->where('ad_id',$ad->id)->first();
                    if(!$check){
                        $subscription = new subscriptions();
                        $subscription->chat_id = $this->user->chat_id;
                        $subscription->ad_id = $ad->id;
                        $subscription->save();
                        $ad->count-=1;
                        $ad->save();
                        return $this->api->execute("sendMessage",[
                            "text" => $ad->text
                        ]);
                    }
                }
                return true;
            }
        }




        $client = new Client();
        $search_request = $client->request('GET', "https://tgram.online/api/books.get", [
            'query' => [
                'fb_id' => $data[0],
                'callback' => json_encode([
                    'url' => 'https://goodlib.teleadmin.ru/api_books_callback',
                    'data' => [
                        'chat_id' => $this->user->chat_id,
                        'type' => $data[1]
                    ]
                ])
            ]
        ]);

        $result_json = $search_request->getBody();



        $result = json_decode($result_json);
        if($result->book){
            $res = $this->api->execute("sendDocument",[
                "document" => $result->book->{$data[1]},
                "token" => $this->fbooks_tokens[$result->book->bot],
                "chat_id" => "-1001320252552",
            ]);

            $this->api->execute("sendDocument",[
                "document" => $result->book->{$data[1]},
                'caption' => '[@goodlib_bot](t.me/goodlib_bot?start=share)'
            ]);
        }
    }

    public function aBook($id){

        $this->api->execute("sendMessage",[
            "text" => "Пожалуйста, подождите, мы уже готовим для вас книгу 😊",
        ]);

        $client = new Client();

        $search_request = $client->request('GET', "https://tgram.online/api/books.get", [
            'query' => [
                'id' => $id
            ]
        ]);

        $result_json = $search_request->getBody();
        $result = json_decode($result_json);

        $audio_parts = audio_parts::where('audio_book_id',$id)->first();
        if(!$audio_parts){
            $audio_parts = new audio_parts();
            $audio_parts->audio_book_id = $id;
            $audio_parts->parts = json_encode($result->parts);
            $audio_parts->save();
        }

        $message = "*{$result->book->title} - {$result->book->authors}*\n\n";
        $message .= "Озвучка: {$result->book->reader}\n";
        $message .= "{$result->book->description}";
        $message = strip_tags($message);
        $message = str_replace("&quot;",'"',$message);
        $this->api->execute("sendMessage",[
            "text" => $message,
            "inline_keyboard" => [
                [['text' => "Слушать","callback_data" => "main:aBookListen:{$id}:0"]]
            ]
        ]);
    }

    public function aBookListen($params){

        foreach (["-1001265138340","-1001493534464","-1001264980224"] as $channel) {
$res = $this->api->execute("getChatMember", [
                'chat_id' => $channel,
                'user_id' => $this->user->chat_id
            ]);
            if($res->ok == true and ($res->result->status == "member" or $res->result->status == "administrator" or $res->result->status == "creator" or $res->result->status == "restricted" or $res->result->status == "kicked")) {
            } else {
                return $this->api->execute("sendMessage", [
                    "text" => "Отличный выбор![⠀](https://telegra.ph/file/ef1d1be7d1201945252cf.png)\n\n"
                        ."✅ Чтобы пользоваться ботом бесплатно и скачивать книги, сделай одно (но обязательное) действие.\n\n"
                        ."Подпишись на 3 канала: \n\n"
                        ."[@Study_BOARD](https://t.me/Study_BOARD)\n"
                        ."[Аудиокниги каждый день 📚](https://t.me/audioknigi_everyday)\n"
                        ."[@knizhnikc](https://t.me/knizhnikc)\n\n"
                        ."После подписки нажми еще раз нужную цифру с книгой и, вуа-ля, она скачается =)",
                    "disable_web_page_preview" => false,
                    "inline_keyboard" => [
                        [['text' => "Подписаться на канал №1", "url" => "https://t.me/Study_BOARD"]],
                        [['text' => "Подписаться на канал №2", "url" => "https://t.me/audioknigi_everyday"]],
                        [['text' => "Подписаться на канал №3", "url" => "https://t.me/knizhnikc"]],
                        [["text" => "Проверить подписку", "callback_data" => "main:check_subscribe"]]
                    ]
                ]);
            }
        }


        $page = $params['data'][1];
        $next_page = $page+1;



        $audio_parts = audio_parts::where('audio_book_id',$params['data'][0])->first();

        $audio_tokens = [
            1 => '1625982191:AAFdoGMJuR8jLd2703PZiCwuTudmhHAs6c8',
            2 => '1689450104:AAEPOKPbK-ZXb7ynF6eR8eA9nYymngCUzdw',
            3 => '1601563235:AAHDtb-0YCDW6Qq_59H41Y5mQKu4pIb5nVQ',
            4 => '1699170696:AAGotakurh4wNBt72gw33lTDKvKkXBAle54',
            5 => '1618242776:AAEKr0j1N4yqja60MGT8jTgytec6Rh7gPFg',
            6 => '1602572486:AAFqM39M0XGCM6-jawpyTcDoy6ZwQ_G4ZSw',
            7 => '1634081195:AAHknjF3dV1-3yvBi6BEQCQTSSQyMNkHeTE',
            8 => '1578079672:AAG2NGzp3miIwfJtyBjZpwcT2bb9BJZRgsw'
        ];

        $audio_parts = json_decode($audio_parts->parts,true);
        $audio_parts_count = count($audio_parts);

        $l = 0;

        foreach ($audio_parts as $audio_part) {
            $l++;
            $is_last = $l >= $audio_parts_count ? true : false;
            if($l > $page * 5 and $l <= $page * 5 + 5){
                $res = $this->api->execute("sendAudio",[
                    'audio' => $audio_part['file_id'],
                    'caption' => '[@goodlib_bot](t.me/goodlib_bot?start=share)',
                    'inline_keyboard' => (($l == count($audio_parts) or $l == $page*5 + 5) and !$is_last) ? [
                        [[
                            'text' => "Слушать далее ❯",
                            'callback_data' => "main:aBookListen:{$params['data'][0]}:". $next_page
                        ]]
                    ] : 0
                ]);
                if($res->ok==false){


                    $res = $this->api->execute("sendAudio",[
                        "chat_id" => "-1001413063944",
                        "token" => $audio_tokens[$audio_part['bot']],
                        'audio' => $audio_part['file_id'],
                    ]);

                    $this->api->execute("sendAudio",[
                        'audio' => $audio_part['file_id'],
                        'caption' => '[@goodlib_bot](t.me/goodlib_bot?start=share)',
                        'inline_keyboard' => (($l == count($audio_parts) or $l == $page*5 + 5) and !$is_last) ? [
                            [[
                                'text' => "Слушать далее ❯",
                                'callback_data' => "main:aBookListen:{$params['data'][0]}:". $next_page
                            ]]
                        ] : 0
                    ]);
                }
            }

        }

        $ads = ads::where('count','>',0)->get();

        foreach ($ads as $ad){
            $check = subscriptions::where('chat_id',$this->user->chat_id)->where('ad_id',$ad->id)->first();
            if(!$check){
                $subscription = new subscriptions();
                $subscription->chat_id = $this->user->chat_id;
                $subscription->ad_id = $ad->id;
                $subscription->save();
                $ad->count-=1;
                $ad->save();
                return $this->api->execute("sendMessage",[
                    "text" => $ad->text
                ]);
            }
        }
    }





    public function fBook($id){


        $book = flibusta_catalog::where('flibusta_id',$id)->first();

        $this->api->execute("sendMessage",[
            "text" => "<b>{$book->first_name} {$book->middle_name} {$book->last_name} - {$book->title}</b>",
            "inline_keyboard" => [
                [
                    ['text' => 'fb2','callback_data' => "main:fBookGet:{$id}:fb2"],
                    ['text' => 'epub','callback_data' => "main:fBookGet:{$id}:epub"],
                    ['text' => 'mobi','callback_data' => "main:fBookGet:{$id}:mobi"]
                ]
            ],
            'parse_mode' => 'html'
        ]);


    }

    public function search($text){

        $message_id = $this->api->execute("sendMessage",[
            "text" => "🔎 Ожидайте, идёт поиск.."
        ])->result->message_id;


        $search_cache = search_cache::where('query',$text)->first();


        if($search_cache){
            return $this->select_type([
                'data' => [$search_cache->id],
                'message_id' => $message_id
            ]);
        }

        $client = new Client();
        $search_request = $client->request('GET', "https://tgram.online/api/books.search", [
            'query' => [
                'type' => 'all',
                'q' => $text
            ]
        ]);
        $result_json = $search_request->getBody();
        $result = json_decode($result_json,true);


        $search_local = flibusta::where('query','like',"%{$text}%")->get();
        if(count($search_local)>0){
            foreach ($search_local as $item) {
                $result['text_list'][] = [
                    "id" => $item->id,
                    "query"=> $item->query,
                    "first_name"=> $item->first_name,
                    "middle_name"=> $item->middle_name,
                    "last_name"=> $item->last_name,
                    "title"=> $item->title,
                    "year"=> $item->year,
                    "collection"=> $item->collection,
                    "image"=> $item->image,
                    "lang"=> $item->ru,
                    "flibusta_id"=> $item->flibusta_id,
                ];
            }
        }

        $result = json_decode(json_encode($result));

        if(count($result->text_list)==0 and count($result->audio_list)==0){
            return $this->api->execute("editMessageText",[
                "message_id" => $message_id,
                "text" => "По вашему запросу не найдено книг."
            ]);
        }

        $search_cache = new search_cache();
        $search_cache->query = $text;
        $search_cache->books = json_encode($result);
        $search_cache->time = time();
        $search_cache->save();

        $this->select_type([
            'data' => [$search_cache->id],
            'message_id' => $message_id
        ]);

    }


    public function select_type($params){
        $data = $params['data'];
        $message_id = $params['message_id'];
        $cache_id = $data[0];

        $cache = search_cache::where('id',$cache_id)->first();


        if(!$cache){
            return $this->api->execute('editMessageText',[
                'text' => 'Извините, поисковая выдача устарела, повторите попытку.',
                'message_id' => $message_id
            ]);
        }
        $result = json_decode($cache->books,true);




        $count_books = count($result['text_list']);
        $count_audio_books = count($result['audio_list']);


        $buttons = [];

        if($count_books>0){
            $word = $this->format_by_count($count_books,"Книга","Книги","Книг");
            $buttons[] = [[
                "text" => "📖 {$count_books} {$word}","callback_data" => "main:list:{$cache_id}:text_list:0"
            ]];
        }
        if($count_audio_books>0){
            $word = $this->format_by_count($count_audio_books,"Книга","Книги","Книг");
            $buttons[] = [[
                "text" => "🎵 {$count_audio_books} Аудио {$word}","callback_data" => "main:list:{$cache_id}:audio_list:0"
            ]];
        }


        return $this->api->execute('editMessageText',[
            'text' => "По вашему запросу \"{$cache->query}\" найдено:",
            "inline_keyboard" => $buttons,
            'message_id' => $message_id
        ]);

    }

    public function format_by_count($count, $form1, $form2, $form3)
    {
        $count = abs($count) % 100;
        $lcount = $count % 10;
        if ($count >= 11 && $count <= 19) return($form3);
        if ($lcount >= 2 && $lcount <= 4) return($form2);
        if ($lcount == 1) return($form1);
        return $form3;
    }

    public function list($params){
        $data = $params['data'];
        $message_id = $params['message_id'];

        $cache_id = $data[0];
        $type = $data[1];
        $page = $data[2];

        $cache = search_cache::where('id',$cache_id)->first();
        if(!$cache){
            return $this->api->execute('editMessageText',[
                'text' => 'Извините, поисковая выдача устарела, повторите попытку.',
                'message_id' => $message_id
            ]);
        }

        $books = json_decode($cache->books,true);

        $books = $books[$type];


        $count_books = count($books);
        $count_pages = ceil($count_books/8);
        $books = array_slice($books,$page*8, 8);


        $message = "🔍 Поиск по запросу: \"{$cache->query}\":\n\n";

        foreach ($books as $book) {
            if(isset($book['flibusta_id'])){
                $message .= "📖 /f_{$book['flibusta_id']} <b>{$book['title']}</b> - {$book['first_name']} {$book['middle_name']} {$book['last_name']}\n\n";
            }else{
                $message .= "🎵 /a_{$book['id']} <b>{$book['title']}</b> - {$book['authors']}\n\n";
            }
        }

        //$message.="";

        $controls = [];

        if($page>0){
            $controls[] = [
                'text' => "Назад",
                "callback_data" => "main:list:{$cache_id}:{$type}:".($page-1)
            ];
        }
        $controls[] = [
            'text' => "Страница ".($page+1)." / {$count_pages}",
            "callback_data" => "currpage"
        ];
        if($page < $count_pages-1){
            $controls[] = [
                'text' => "Вперёд",
                "callback_data" => "main:list:{$cache_id}:{$type}:".($page+1)
            ];
        }

        $this->api->execute('editMessageText',[
            'text' => $message,
            'message_id' => $message_id,
            'parse_mode' => 'html',
            'inline_keyboard' => [$controls]
        ]);





    }


}
