<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>TELEADMIN</title>
    <script
        src="https://code.jquery.com/jquery-3.4.1.js"
        integrity="sha256-WpOohJOqMqqyKL9FccASB9O0KwACQJpFTUBLTYOVvVU="
        crossorigin="anonymous"></script>
    <!-- Scripts -->
    <script src="<?php echo e(asset('js/bootstrap.js')); ?>" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/js/all.min.js"></script>
    <script src="/js/notify.js"></script>
    <!-- Styles -->
    <link href="https://bootswatch.com/4/darkly/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('css/styles.css')); ?>" rel="stylesheet">


    <script src="https://www.chartjs.org/dist/2.9.3/Chart.min.js"></script>


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/jquery.datetimepicker.min.css" />

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/build/jquery.datetimepicker.full.min.js"></script>



    <style>
        .importantRule { background-color: #30b817 !important; }

    </style>
</head>
<body>
<div id="app">


    <nav class="navbar navbar-expand-md navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                TELEADMIN
            </a>
            <a href="javascript:void(0)" onclick="reboot()"><i class="fas fa-redo-alt"></i></a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <!-- Left Side Of Navbar -->
                <ul class="navbar-nav mr-auto">

                </ul>

                <!-- Right Side Of Navbar -->
                <ul class="navbar-nav ml-auto">
                    <!-- Authentication Links -->
                    <?php if(auth()->guard()->guest()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                        </li>
                        <?php if(Route::has('register')): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php else: ?>
                        <li class="nav-item dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                <?php echo e(Auth::user()->name); ?> <span class="caret"></span>
                            </a>

                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                   onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">Выход
                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <main class="py-4">

        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-4">
                    <?php if(Auth::id()!=4): ?>

                    <?php if(Auth::id()!=3): ?>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=vksound">статистика vksound_bot</a>
                        <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=ivksound">статистика ivksound_bot</a>
                        <br>
                    <?php endif; ?>
                        <i class="fas fa-chart-line"></i>  <a href="https://admin.teleadmin.ru/stats?bot=stormbot">статистика audio_storm_bot</a>
                    <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=booksbot">статистика reader_robot</a>
                    <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=goodlib">статистика goodlib_bot</a>
                        <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=knigavsluh">статистика knigavsluh</a>
                        <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=flibusta">статистика flibusta</a>
                        <br>


                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=smotrikino">статистика smotri_kino_bot</a>
                        <hr>
                         <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=music">статистика music_telebot</a>
                        <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=player">статистика player_robot</a>
                        <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=volume">статистика volume_robot</a>
                        <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=fuck_dmca">статистика fuck_dmca_bot</a>
                        <hr>

                    <?php endif; ?>

                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=lokkkatorbot">статистика lokkkatorbot</a>
                        <br>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=lovebot">статистика lovebot</a>
                        <hr>
                        <i class="fas fa-chart-line"></i> <a href="https://admin.teleadmin.ru/stats?bot=gdedrug">статистика gdedrug</a>
                        <hr>

                    <a href="https://admin.teleadmin.ru/broadcast">рассылка в ботах</a>

                        <div class="bots_status">

                        </div>




                    <hr>

                    <div class=" mt-3"><i class="fas fa-microchip"></i> CPU: </div>
                    <div class="progress">
                        <div class="cpu-usage progress-bar  bg-danger progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
                            <span class="cpu-percentage"></span>
                        </div>
                    </div>

                        <div class=" mt-3"><i class="fas fa-sd-card"></i> MEMORY: </div>
                        <div class="progress">
                            <div class="memory-usage progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
                                <span class="memory-percentage"></span>
                            </div>
                        </div>

                        <div class=" mt-3"><i class="fas fa-compact-disc"></i> DISK: </div>
                        <div class="progress">
                            <div class="disk-usage progress-bar bg-success progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
                                <span class="disk-percentage"></span>
                            </div>
                        </div>



                    <hr>

                    <?php for($i=1;$i<=0;$i++): ?>
                        <div class="progress progress-file-<?php echo e($i); ?> mt-1">
                            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 0%"></div>
                        </div>
                    <?php endfor; ?>

                </div>
                <div class="col-md-8">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </main>
</div>
<script src="https://admin.teleadmin.ru:2083/socket.io/socket.io.js"></script>

<script>

    function stopBroadcast(bot){
        $.post('https://admin.teleadmin.ru/admin/stopBroadcast',{
            bot:bot,
            _token:$('meta[name="csrf-token"]').attr('content')
        },function (data) {
            //location.reload();
        });
    }


    function getBotsInfo() {
        $.get('https://admin.teleadmin.ru/admin/broadcastInfo',function (data) {

            for(bot in data.bots){
                let index = bot.substr(0,5);
                console.log(index);
                $('.bots_status').append(`<div class="${index}-pc d-flex align-items-center mt-2"> <div class="d-flex mr-1"> ${index} <div class="${index}-counter"></div></div> <div class="progress  d-flex flex-grow-1"> <div class="${index}-progress progress-bar bg-info progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 100%"> <span class="${index}-percent"> </span> </div> </div> <i class="far fa-stop-circle ml-1" onclick="stopBroadcast('${bot}')"></i> </div>`)
            }


        });

    }
    getBotsInfo();

    function reboot() {
        $.post('https://admin.teleadmin.ru/admin/reboot',{
            _token:$('meta[name="csrf-token"]').attr('content')
        }, function (data) {
            setTimeout(function () {
                location.reload();
            },20000)
        });
    }

    function updateBroadcastInfo() {
        $.get('https://admin.teleadmin.ru/admin/broadcastInfo',function (data) {

            for(bot in data.bots){
                let index = bot.substr(0,5);

                $(`.${index}-pc`).css('display','flex');
                $(`.${index}-progress`).css('width',`${data.bots[bot]['counter']}%`);
                $(`.${index}-counter`).html(': '+data.bots[bot]['counter']+'% ('+data.bots[bot]['last_id']+'/'+data.bots[bot]['all_count']+')');

                if(data.bots[bot]['status']==1){
                    $(`.${index}-progress`).addClass('importantRule');
                }


            }

        });

    }

    updateBroadcastInfo();
    setInterval(updateBroadcastInfo,15000);

    var socket = io('https://admin.teleadmin.ru:2083');
    socket.connect();
    socket.on('message', function(data) {
        if(data.cpu){
            $('.cpu-usage').css('width',data.cpu/3+'%');
            $('.cpu-percentage').html(Math.round(data.cpu/3)+'%');
            $('.memory-usage').css('width',data.memory+'%');
            $('.memory-percentage').html(data.memory+'%');
            $('.disk-usage').css('width',data.disk+'%');
            $('.disk-percentage').html(data.disk_gb+'GB / 437GB');
        }

        for(var i = 1;i<=30;i++){
            if(data[`file_${i}`]) {
                console.log(data[`file_${i}`]);
                $(`.progress-file-${i} div`).css('width',data[`file_${i}`]+'%')
                $(`.progress-file-${i} div`).html(data[`file_${i}`]+'%')
            }
        }

        if(data.bot){

            if(data.bot == "knigavsluh"){
                $('.knigavsluh_bot-pc').css('display','flex');
                $('.knigavsluh_bot-progress').css('width',data.progress+'%');
                $('.knigavsluh_bot-percent').html(data.progress+'%');
            }
            if(data.bot == "vksound"){
                $('.vksound_bot-pc').css('display','flex');
                $('.vksound_bot-progress').css('width',data.progress+'%');
                $('.vksound_bot-percent').html(data.progress+'%');
            }
            if(data.bot == "ivksound"){
                $('.ivksound_bot-pc').css('display','flex');
                $('.ivksound_bot-progress').css('width',data.progress+'%');
                $('.ivksound_bot-percent').html(data.progress+'%');
            }
            if(data.bot == "player"){
                $('.player_bot-pc').css('display','flex');
                $('.player_bot-progress').css('width',data.progress+'%');
                $('.player_bot-percent').html(data.progress+'%');
            }
            if(data.bot == "stormbot"){
                $('.stormbot_bot-pc').css('display','flex');
                $('.stormbot_bot-progress').css('width',data.progress+'%');
                $('.stormbot_bot-percent').html(data.progress+'%');
            }
            if(data.bot == "booksbot"){
                $('.booksbot-pc').css('display','flex');
                $('.booksbot-progress').css('width',data.progress+'%');
                $('.booksbot-percent').html(data.progress+'%');
            }
            if(data.bot == "goodlib"){
                $('.goodlib-pc').css('display','flex');
                $('.goodlib-progress').css('width',data.progress+'%');
                $('.goodlib-percent').html(data.progress+'%');
            }
            if(data.bot == "smotrikino"){
                $('.smotrikino-pc').css('display','flex');
                $('.smotrikino-progress').css('width',data.progress+'%');
                $('.smotrikino-percent').html(data.progress+'%');
            }
            if(data.bot == "lokkkatorbot"){
                $('.lokkkatorbot-pc').css('display','flex');
                $('.lokkkatorbot-progress').css('width',data.progress+'%');
                $('.lokkkatorbot-percent').html(data.progress+'%');
            }
        }
    });
</script>
</body>
</html>
<?php /**PATH /var/www/html/admin/resources/views/layouts/auth.blade.php ENDPATH**/ ?>