<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redis;


Auth::routes();

Route::get('/', 'AdminController@index');
Route::get('/home', 'AdminController@index');
Route::get('/broadcast', 'AdminController@broadcast');


Route::get('/vksound_stats', 'AdminController@vksound_stats');
Route::get('/storm_stats', 'AdminController@storm_stats');
Route::get('/reader_stats', 'AdminController@reader_stats');
Route::get('/goodlib_stats', 'AdminController@goodlib_stats');
Route::get('/smotrikino_stats', 'AdminController@smotrikino_stats');
Route::get('/stats', 'AdminController@stats');
Route::get('/get_stats', 'AdminController@get_stats');

Route::get('/vksound_chart', 'AdminController@vksound_chart');
Route::get('/storm_chart', 'AdminController@storm_chart');
Route::get('/reader_chart', 'AdminController@reader_chart');
Route::get('/goodlib_chart', 'AdminController@goodlib_chart');
Route::get('/smotrikino_chart', 'AdminController@smotrikino_chart');

Route::post('/admin/savePost','AdminController@savePost');
Route::post('/admin/startBroadcast','AdminController@startBroadcast');
Route::post('/admin/savePendingBroadcast','AdminController@savePendingBroadcast');

Route::get('/admin/broadcastInfo','AdminController@broadcastInfo');
Route::post('/admin/stopBroadcast','AdminController@stopBroadcast');
Route::post('/admin/deletePending','AdminController@deletePending');


Route::get('/admin/checkBroadcast','PublicController@checkBroadcast');
Route::get('/broadcast_stats','PublicController@broadcast_stats');
Route::post('/admin/reboot','AdminController@reboot');

Route::get('/admin/getUsersTxt','UsersChecker@getUsersTxt');
