@extends('layouts.auth')

@section('content')

    <h4>Статистика {{$bot}}</h4>
    <hr>


    <div class="preloader w-100 text-center">
        <h4>Загрузка статистики</h4>
        <div class="spinner-border" role="status">
            <span class="sr-only">Loading...</span>
        </div>
    </div>


    <div class="info" style="display: none">

        <div class="row">
            <div class="col-md-12 mb-3">
                <div class="card">
                    <div class="card-body">
                        <div class="card-text">
                            <div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="period" id="hours" value="hours">
                                    <label class="form-check-label" for="hours">
                                        Часы
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="period" id="days" value="days" checked>
                                    <label class="form-check-label" for="days">
                                        Дни
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="period" id="weeks" value="weeks">
                                    <label class="form-check-label" for="weeks">
                                        Недели
                                    </label>
                                </div>
                            </div>
                            <hr>

                            <select id="refs" class="form-control form-control-sm">

                            </select>

                            <hr>
                            <h4 class="last_day"></h4>
                            <div style="height: 500px;"><canvas id="chart"></canvas></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">


                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">
                            <div class=" d-flex justify-content-between">
                                <div style="font-weight: bold">Пользователей:</div>
                                <div><span id="count_users"></span> <i class="fas fa-user"></i></div>
                            </div>
                        </h5>
                        <h6 class="card-subtitle mb-2 text-muted">Метрика активности:</h6>

                        <div class="card-text">
                            <div><b>1 день:</b><span id="day_1"></span></div>
                            <div><b>2 день:</b><span id="day_2"></span></div>
                            <div><b>3 день:</b><span id="day_3"></span></div>
                            <div><b>4 день:</b><span id="day_4"></span></div>
                            <div><b>5 день:</b><span id="day_5"></span></div>
                            <div><b>10 день:</b><span id="day_10"></span></div>
                            <div><b>30 день:</b><span id="day_30"></span></div>
                        </div>
                    </div>
                </div>




            </div>
            <div class="col-md-6">

                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">
                            <div class=" d-flex justify-content-between">
                                <div style="font-weight: bold">Рефералка:</div>
                            </div>
                        </h5>

                        <div class="ref_stats">

                        </div>
                    </div>
                </div>

            </div>


        </div>

    </div>

    <script>



        stats_chart = new Chart('chart',{
            type: "line",

        });
        var period = "days";
        var follow_ref = "all";


        function getStats(){

            $('.preloader').show();
            $('.info').hide();
            $.get('https://admin.teleadmin.ru/get_stats',{
                bot: '{{$bot}}',
                period: period,
                follow_ref: follow_ref,
                _token:$('meta[name="csrf-token"]').attr('content')
            },function(data){
                $('.preloader').hide();
                $('.info').show();
                console.log(data);
                $('#count_users').html(data.count_users);
                $('#day_1').html(data.day_1);
                $('#day_2').html(data.day_2);
                $('#day_3').html(data.day_3);
                $('#day_4').html(data.day_4);
                $('#day_5').html(data.day_5);
                $('#day_10').html(data.day_10);
                $('#day_30').html(data.day_30);

                $('#refs').html('<option value="all">Показать все</option>');
                $('.ref_stats').html('');
                for(var i=0;i<data.ref_stats.length;i++){
                    $('.ref_stats').append('<div><i class="fas fa-caret-right"></i> '+data.ref_stats[i].ref+': '+data.ref_stats[i].count+'</div>')
                    let selected = "";
                    console.log(follow_ref,data.ref_stats[i].ref);
                    if(follow_ref==data.ref_stats[i].ref){
                        selected = "selected";
                    }
                    $('#refs').append('<option value="'+data.ref_stats[i].ref+'" '+selected+'>'+data.ref_stats[i].ref+'</option>')
                }



                labels = [];
                data.chart.chart.map(function(item,key){
                    labels.push(item.date);
                });

                values = [];
                data.chart.chart.map(function(item,key){
                    values.push(item.count);
                });

                let phrases = {
                    1: {
                        'hours' : 'За последний час: ',
                        'days' : 'За последний день: ',
                        'weeks' : 'за последнюю неделю: ',
                    },
                    2: {
                        'hours' : 'Новых за час: ',
                        'days' : 'Новых за день: ',
                        'weeks' : 'Новых за неделю: ',
                    }
                }

                $('.last_day').html(phrases[1][data.chart.type] + data.chart.last+ ` [${follow_ref == "all" ? "все" : follow_ref}]`);



                stats_chart.data = {
                    labels: labels,
                    datasets: [{
                        backgroundColor: "rgba(255, 99, 132, 0.5)",
                        borderColor: "rgb(255, 99, 132)",
                        data: values,
                        label: phrases[2][data.chart.type],
                        fill: "start"
                    }]
                };
                stats_chart.type = "line";
                stats_chart.options = {
                    maintainAspectRatio: false,
                    spanGaps: false,
                    elements: {
                        line: {
                            tension: 0.000001
                        }
                    },
                    plugins: {
                        filler: {
                            propagate: false
                        }
                    },
                    title: {
                        text: 'График прироста',
                        display: true
                    },
                    scales: {
                        xAxes: [{
                            scaleLabel: {
                                display: true,
                                labelString: 'Период'
                            }
                        }],
                    }
                };


                stats_chart.update();

            });
        }

        $(function () {
            $('#refs').change(function () {
                follow_ref = $('#refs').val()
                getStats()
            })
            $('input[name=period]').change(function () {
                period = $('input[name=period]:checked').val();
                getStats();
            })
            getStats();
        })
    </script>




@endsection
