var fs = require( 'fs' );
var app = require('express')();
var https        = require('https');
var redis        = require('redis');

var server = https.createServer({

    key: fs.readFileSync('/var/www/html/ssl/cert.key'),
    cert: fs.readFileSync('/var/www/html/ssl/cert.pem')
},app);

var io = require('socket.io').listen(server);

io.sockets.on('connection',function (socket) {
    console.log('new connect');

    var subscriber = redis.createClient();

    var publisher  = redis.createClient();

    subscriber.subscribe('update');

    subscriber.on("error", function (err) {
        console.log("Error " + err);
    });

    subscriber.on('message', function (channel,message) {
        console.log(message);
        message = JSON.parse(message);
        socket.emit("message",message);
    });

    subscriber.on('disconnect',function(){
        redisClient.quit();
    });

    publisher.publish("message", '{"message":"text"}');

});
server.listen(2083);


