<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redis;
use App\Log;

class PublicController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    public function broadcast_stats(){

        $log_one = json_decode(Log::where('text','like','%"bot":"ivksound"%')->orderBy('id','desc')->first()->text);
        $log_two = json_decode(Log::where('text','like','%"bot":"vksound"%')->orderBy('id','desc')->first()->text);
        $log = [
            'success'=>$log_one->success + $log_two->success,
            'all' => $log_one->all + $log_two->all,
            'date'=>$log_one->date
        ];

        return json_encode($log);
    }

    private function sendMessageAdmins($text){
        $this->api("sendMessage",[
            'text'=>$text,
            'chat_id'=> 1250349080
        ],"1307017460:AAF_DfPVihMEE22UzxVCFi2yh3kzBDrLe8A");

        $this->api("sendMessage",[
            'text'=>$text,
            'chat_id'=> 271592734
        ],"1307017460:AAF_DfPVihMEE22UzxVCFi2yh3kzBDrLe8A");
    }




    private function api($method,$params,$token){
        if(!isset($params['parse_mode'])) {
            $params['parse_mode'] = "markdown";
        }
        if(isset($params['inline_keyboard'])) {
            $params['reply_markup'] = json_encode(['resize_keyboard' => true, 'inline_keyboard' => $params['inline_keyboard']]);
            unset($params['inline_keyboard']);
        }
        if(isset($params['keyboard'])) {
            $params['reply_markup'] = json_encode(['resize_keyboard' => true, 'keyboard' => $params['keyboard']]);
            unset($params['keyboard']);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch,  CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot{$token}/{$method}");
        $data = curl_exec($ch);
        $data = json_decode($data);
        curl_close($ch);
        return $data;
    }



    public function checkBroadcast()
    {
        $redis = Redis::connection();

        $vksound_last_id = $redis->get("vksound_last_id");
        $ivksound_last_id = $redis->get("ivksound_last_id");
        $stormbot_last_id = $redis->get("stormbot_last_id");
        $player_last_id = $redis->get("player_last_id");
        $booksbot_last_id = $redis->get("booksbot_last_id");
        $smotrikino_last_id = $redis->get("smotrikino_last_id");

        $vksound_is_run = !empty(exec('ps aux | grep "[b]roadcast:start vksound"')) ? 1 : 0;
        $ivksound_is_run = !empty(exec('ps aux | grep "[b]roadcast:start ivksound"')) ? 1 : 0;
        $stormbot_is_run = !empty(exec('ps aux | grep "[b]roadcast:start stormbot"')) ? 1 : 0;
        $player_is_run = !empty(exec('ps aux | grep "[b]roadcast:start player"')) ? 1 : 0;
        $booksbot_is_run = !empty(exec('ps aux | grep "[b]roadcast:start booksbot"')) ? 1 : 0;
        $smotrikino_is_run = !empty(exec('ps aux | grep "[b]roadcast:start smotrikino"')) ? 1 : 0;


        $vksound_all_count = $redis->get("vksound_all_count");
        $ivksound_all_count = $redis->get("ivksound_all_count");
        $stormbot_all_count = $redis->get("stormbot_all_count");
        $player_all_count = $redis->get("player_all_count");
        $booksbot_all_count = $redis->get("booksbot_all_count");
        $smotrikino_all_count = $redis->get("smotrikino_all_count");


        if($vksound_is_run==0 and $vksound_last_id+100 < $vksound_all_count){
            $vksound_last_id_attension = $redis->get("vksound_last_id_attension");
            if($vksound_last_id_attension != $vksound_last_id){
                $redis->set("vksound_last_id_attension",$vksound_last_id);
                $this->sendMessageAdmins("Прервана рассылка в vksound");
            }
        }

        if($ivksound_is_run==0 and $ivksound_last_id+100 < $ivksound_all_count){
            $ivksound_last_id_attension = $redis->get("ivksound_last_id_attension");
            if ($ivksound_last_id_attension != $ivksound_last_id) {
                $redis->set("ivksound_last_id_attension", $ivksound_last_id);
                $this->sendMessageAdmins("Прервана рассылка в ivksound");
            }
        }

        if($stormbot_is_run==0 and $stormbot_last_id+100 < $stormbot_all_count){
            $stormbot_last_id_attension = $redis->get("stormbot_last_id_attension");
            if($stormbot_last_id_attension != $stormbot_last_id){
                $redis->set("stormbot_last_id_attension",$stormbot_last_id);
                $this->sendMessageAdmins("Прервана рассылка в stormbot");
            }
        }



        if($player_is_run==0 and $player_last_id+100 < $player_all_count){
            $player_last_id_attension = $redis->get("player_last_id_attension");
            if($player_last_id_attension != $player_last_id){
                $redis->set("player_last_id_attension",$player_last_id);
                $this->sendMessageAdmins("Прервана рассылка в player");
            }
        }

        if($booksbot_is_run!=1 and $booksbot_last_id+100 < $booksbot_all_count){
            $booksbot_last_id_attension = $redis->get("booksbot_last_id_attension");
            if($booksbot_last_id_attension != $booksbot_last_id){
                $redis->set("booksbot_last_id_attension",$booksbot_last_id);
                $this->sendMessageAdmins("Прервана рассылка в booksbot");
            }
        }


        if($smotrikino_is_run!=1 and $smotrikino_last_id+100 < $smotrikino_all_count){
            $smotrikino_last_id_attension = $redis->get("smotrikino_last_id_attension");
            if($smotrikino_last_id_attension != $smotrikino_last_id){
                $redis->set("smotrikino_last_id_attension",$smotrikino_last_id);
                $this->sendMessageAdmins("Прервана рассылка в smotrikino");
            }
        }

        echo 'test';

    }

}
