<?php

namespace App\Http\Controllers;

use App\Log;
use App\Posting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redis;
use phpseclib\Net\SSH2;


class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function index()
    {
        return view('home');
    }

    public function savePost(Request $request){
        $text = $request->text;
        $file = $request->file;
        $with_video = $request->with_video;
        $with_animation = $request->with_animation;
        $buttons = $request->buttons;
        $with_image = $request->with_image;
        $check_members = $request->check_members;
        $speed = $request->speed;
        $offset = $request->offset;
        $with_keyboard = $request->with_keyboard;
        $disable_web_page_preview = $request->disable_web_page_preview;
        $json = [
            'text'=>$text,
            'file'=>$file,
            'buttons'=>json_decode($buttons),
            'with_image'=>$with_image,
            'with_video'=>$with_video,
            'check_members'=>$check_members,
            'with_animation'=>$with_animation,
            'with_keyboard'=>$with_keyboard,
            'speed' => $speed,
            'offset' => $offset,
            'disable_web_page_preview'=>$disable_web_page_preview
        ];
        $json = json_encode($json);
        file_put_contents('/var/www/html/admin/storage/app/public/post.txt',$json);
        shell_exec("php /var/www/html/admin/artisan broadcast:start test '{$json}'");
        return "php /var/www/html/admin/artisan broadcast:start test '{$json}'";
    }

    public function reboot(){
        $ssh = new SSH2('95.217.202.119');
        if (!$ssh->login('root', 'cyberpunk20774815162342')) {
            exit('Login Failed');
        }
        $ssh->write("reboot\n");
        echo $ssh->read('start reboot:');
    }

    public function stopBroadcast(Request $request){


        $text = "Нажата кнопка остановить рассылку";
        $this->api("sendMessage",[
            'text'=>$text,
            'chat_id'=> 1250349080
        ],"1307017460:AAF_DfPVihMEE22UzxVCFi2yh3kzBDrLe8A");
        $this->api("sendMessage",[
            'text'=>$text,
            'chat_id'=> 271592734
        ],"1307017460:AAF_DfPVihMEE22UzxVCFi2yh3kzBDrLe8A");



        $ssh = new SSH2('95.217.202.119');
        if (!$ssh->login('root', 'cyberpunk20774815162342')) {
            exit('Login Failed');
        }
        $ssh->write("pkill -f 'broadcast:start {$request->bot}'\n");
        echo $ssh->read('stop broadcast:');

    }

    public function startBroadcast(Request $request){
        $post = file_get_contents('/var/www/html/admin/storage/app/public/post.txt');
        shell_exec("php /var/www/html/admin/artisan broadcast:start {$request->bot} '{$post}' > /dev/null 2>&1 &");
    }

    public function savePendingBroadcast(Request $request){
        $time = strtotime($request->date);
        if($time<time()){
            return [
                'error' => "Дата отложенной рассылки меньше текущего времени"
            ];
        }
        $post = file_get_contents('/var/www/html/admin/storage/app/public/post.txt');
        $posting = new Posting();
        $posting->bot = $request->bot;
        $posting->post = $post;
        $posting->date = date("U",$time);
        $posting->save();
    }

    public function broadcast(){
        $post =    json_decode(file_get_contents('/var/www/html/admin/storage/app/public/post.txt'));
        $post->buttons = json_decode(json_encode($post->buttons),true);


        $posts = Posting::get()->toArray();
        foreach ($posts as $key => $item) {
            $posts[$key]['post'] = json_decode($item['post']);
            $posts[$key]['post']->text = mb_substr($posts[$key]['post']->text,0,150);
            $posts[$key]['date'] = date("d.m.Y H:i",$item['date']);
        }
        return view('broadcast',['post'=>$post,'posts'=>$posts]);
    }

    public function ncov(){
        $ncov = Redis::get('ncov');
        return view('ncov',['ncov'=>json_decode($ncov,true)]);
    }




    public function stats(Request $request){
        return view('new_stats',['bot'=>$request->bot]);
    }

    public function get_stats(Request $request){
        if(!isset($request->period)){
            $type_period = "days";
        }else{
            $type_period = $request->period;
        }

        if(!isset($request->follow_ref)){
            $follow_ref = "all";
        }else{
            $follow_ref = $request->follow_ref;
        }

        $day_time = 60*60*24;
        $table_name = 'users';



        if($request->bot=='ivksound'){
            $request->bot='vksound';
            $table_name = 'i_users';
        }

        if($request->bot=='player'){
            $request->bot='deezer';
            $table_name = 'p_users';
        }

        if($request->bot=='volume'){
            $request->bot='deezer';
            $table_name = 'v_users';
        }

        if($request->bot=='music'){
            $request->bot='deezer';
            $table_name = 'm_users';
        }

        if($request->bot=='fuck_dmca'){
            $request->bot='deezer';
            $table_name = 'd_users';
        }
        if($request->bot=='lovebot'){
            $request->bot='lovebot';
            $table_name = 'l_users';
        }

        if($request->bot=='gdedrug'){
            $request->bot='gdedrug';
            $table_name = 'a_users';
        }

        if($request->bot=='flibusta'){
            $request->bot='flibusta';
            $table_name = 'users';
        }
        if($request->bot=="placemeet"){
            $request->bot='flibusta';
            $table_name = 'placemeet';
        }



        $db = DB::connection($request->bot);


        $count_users = $db->table($table_name)->count();
        $day_1 = $db->table($table_name)->where('updated','>',time() - $day_time*1)->count();
        $day_2 = $db->table($table_name)->where('updated','>',time() - $day_time*2)->count();
        $day_3 = $db->table($table_name)->where('updated','>',time() - $day_time*3)->count();
        $day_4 = $db->table($table_name)->where('updated','>',time() - $day_time*4)->count();
        $day_5 = $db->table($table_name)->where('updated','>',time() - $day_time*5)->count();
        $day_10 = $db->table($table_name)->where('updated','>',time() - $day_time*10)->count();
        $day_30 = $db->table($table_name)->where('updated','>',time() - $day_time*30)->count();


        $ref_links = [];
        $unic_refs = $db->table($table_name)->select('ref')->where('ref','!=','0')->groupBy('ref','id')->distinct()->get();
        foreach ($unic_refs as $unic_ref) {
            $ref_links[] = $unic_ref->ref;
        }

        $ref_stats = [];

        foreach ($ref_links as $unic_ref) {
            if($unic_ref!='0'){
                $count_users_ref = $db->table($table_name)->where('ref',$unic_ref)->count();
                if($count_users_ref>15){
                    if(empty($unic_ref)){
                        $unic_ref = "Без реф.";
                    }
                    $ref_stats[$count_users_ref] = ['ref'=>$unic_ref,'count'=>$count_users_ref];
                }
            }
        }

        ksort($ref_stats);
        $sort_ref_stats = [];
        foreach ($ref_stats as $ref_stat) {
            $sort_ref_stats[] = $ref_stat;
        }
        $sort_ref_stats = array_reverse($sort_ref_stats);


        $start_time = strtotime(date("m/d/Y H:00:00"));

        if($follow_ref=="Без реф."){
            $follow_ref="";
        }
        switch ($type_period){
            case "hours":
                $users_registered = [];
                for($i = 47;$i>=0;$i--){
                    $date = date('H:i',$start_time - ($i+1) * 60*60);
                    $count = $db->table($table_name)->where('registered',"<",$start_time - $i * 60*60)->where('registered',">",$start_time - ($i+1) * 60*60);
                    if($follow_ref!="all"){
                        $count = $count->where('ref',$follow_ref);
                    }
                    $count = $count->count();
                    $users_registered[] = [
                        'count' => $count,
                        'date' => $date
                    ];
                }
                if($follow_ref!="all") {
                    $last = $db->table($table_name)->where('ref',$follow_ref)->where('registered',">", $start_time -   60 * 60)->where('registered','<',$start_time)->count();
                }else{
                    $last = $db->table($table_name)->where('registered',">", $start_time -  60 * 60)->where('registered','<',$start_time)->count();
                }
                break;
            case "days":
                $users_registered = [];
                for($i = 30;$i>=0;$i--){
                    $date = date('d.m.Y',$start_time - ($i+1) * 60*60*24);
                    $count = $db->table($table_name)->where('registered',"<",$start_time - $i * 60*60*24)->where('registered',">",$start_time - ($i+1) * 60*60*24);
                    if($follow_ref!="all"){
                        $count = $count->where('ref',$follow_ref);
                    }
                    $count = $count->count();
                    $users_registered[] = [
                        'count' => $count,
                        'date' => $date
                    ];
                }
                if($follow_ref!="all") {
                    $last = $db->table($table_name)->where('ref',$follow_ref)->where('registered',">", $start_time - 24 * 60 * 60)->where('registered','<',$start_time)->count();
                }else{
                    $last = $db->table($table_name)->where('registered',">", $start_time - 24 * 60 * 60)->where('registered','<',$start_time)->count();
                }
                break;
            case "weeks":
                $start_time = strtotime('monday this week');
                $users_registered = [];
                for($i = 10;$i>=0;$i--){
                    $date = date('d.m.Y',$start_time- ($i+1) * 60*60*24*7)."-".date('d.m.Y',$start_time - $i * 60*60*24*7);
                    $count = $db->table($table_name)->where('registered',"<",$start_time - $i * 60*60*24*7)->where('registered',">",$start_time - ($i+1) * 60*60*24*7);
                    if($follow_ref!="all"){
                        $count = $count->where('ref',$follow_ref);
                    }
                    $count = $count->count();
                    $users_registered[] = [
                        'count' => $count,
                        'date' => $date
                    ];
                }
                if($follow_ref!="all") {
                    $last = $db->table($table_name)->where('ref',$follow_ref)->where('registered',">", $start_time - 24 * 60 * 60*7)->where('registered','<',$start_time)->count();
                }else{
                    $last = $db->table($table_name)->where('registered',">", $start_time - 24 * 60 * 60*7)->where('registered','<',$start_time)->count();
                }

                break;
        }

        $chart_data = [
            'type' => $type_period,
            'chart' => $users_registered,
            'last' => $last
        ];

        return [
            'count_users'=>$count_users,
            'day_1'=>$day_1,
            'day_2'=>$day_2,
            'day_3'=>$day_3,
            'day_4'=>$day_4,
            'day_5'=>$day_5,
            'day_10'=>$day_10,
            'day_30'=>$day_30,
            'ref_stats' => $sort_ref_stats,
            'chart' => $chart_data
        ];
    }

    public function vksound_stats(){
        return view('stats',['bot'=>'vksound']);
    }

    public function storm_stats(){
        return view('stats',['bot'=>'storm']);
    }

    public function goodlib_stats(){
        return view('stats',['bot'=>'goodlib']);
    }

    public function smotrikino_stats(){
        return view('stats',['bot'=>'smotrikino']);
    }

    public function reader_stats(){
        return view('stats',['bot'=>'reader']);
    }

    public function vksound_chart(){
        return view('charts',['bot'=>'vksound']);
    }

    public function storm_chart(){
        return view('charts',['bot'=>'storm']);
    }

    public function smotrikino_chart(){
        return view('charts',['bot'=>'smotrikino']);
    }

    public function reader_chart(){
        return view('charts',['bot'=>'reader']);
    }

    public function goodlib_chart(){
        return view('charts',['bot'=>'goodlib']);
    }

    public function broadcastInfo(){

        $bots = [
            "vksound",
            "ivksound",
            "stormbot",
            "booksbot",
            "goodlib",
            "smotrikino",
            "player_robot",
            "music_telebot",
            "volume_robot",
            "fuck_dmca_bot",
            "knigavsluh",
            "lokkkatorbot",
            "lovebot",
            "gdedrug",
            "flibusta",
            "placemeet"
        ];

        $redis = Redis::connection();
        $counters = [];

        foreach ($bots as $bot) {
            $counters[$bot]['counter'] = $redis->get($bot);
            if(empty($counters[$bot]['counter'])){
                $redis->set($bot,0);
            }
            $counters[$bot]['last_id'] =  $redis->get("{$bot}_last_id");
            $counters[$bot]['all_count'] =  $redis->get("{$bot}_all_count");
            $counters[$bot]['status'] =  !empty(exec('ps aux | grep "[b]roadcast:start '.$bot.'"')) ? 1 : 0;
        }

        return [
            'bots' => $counters
        ];
    }

    public function deletePending(Request $request){
        $post = Posting::where('id',$request->id)->first();
        $post->delete();
    }


    private function api($method,$params,$token){
        if(!isset($params['parse_mode'])) {
            $params['parse_mode'] = "markdown";
        }
        if(isset($params['inline_keyboard'])) {
            $params['reply_markup'] = json_encode(['resize_keyboard' => true, 'inline_keyboard' => $params['inline_keyboard']]);
            unset($params['inline_keyboard']);
        }
        if(isset($params['keyboard'])) {
            $params['reply_markup'] = json_encode(['resize_keyboard' => true, 'keyboard' => $params['keyboard']]);
            unset($params['keyboard']);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch,  CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot{$token}/{$method}");
        $data = curl_exec($ch);
        $data = json_decode($data);
        curl_close($ch);
        return $data;
    }

}
