<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Redis;





class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {

        $schedule->call(function(){
            $res = file_get_contents("https://www.worldometers.info/coronavirus/");
            $row = $this->getElementValue($res,'<td style="font-weight: bold; font-size:15px; text-align:left;">Russia</td>','</tr>');
            $cols_arr = explode('<td',$row);
            foreach ($cols_arr as $key => $item) {
                $cols_arr[$key] = $this->getElementValue($item,'">',"</td>");
                echo "{$key}: '{$cols_arr[$key]}'<br>";
            }
            Redis::set("ncov", json_encode([
                '0'=>$cols_arr[1],
                '1'=>$cols_arr[2],
                '2'=>$cols_arr[3],
                '3'=>$cols_arr[4],
                '4'=>$cols_arr[5],
                '5'=>$cols_arr[6],
                '6'=>$cols_arr[7],
                '7'=>$cols_arr[8]
            ]));
        })->everyMinute();

    }

    private function getElementValue($string,$strStart,$strEnd){
        $str_search = strpos($string,$strStart);
        if($str_search===false){
            return false;
        }
        $str_1 = substr($string,$str_search+strlen($strStart));
        $str_search = strpos($str_1,$strEnd);
        $res = substr($str_1,0,$str_search);
        return $res;
    }


    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
