<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;




class Test extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }


    public function handle()
    {

        //$type_period = "hours";
        $type_period = "days";
        $follow_ref = "all";
        $follow_ref = "tgorg";
        //$type_period = "weeks";

        $day_time = 60*60*24;
        $db = DB::connection('stormbot');

        $count_users = $db->table('users')->count();
        $day_1 = $db->table('users')->where('updated','>',time() - $day_time*1)->count();
        $day_2 = $db->table('users')->where('updated','>',time() - $day_time*2)->count();
        $day_3 = $db->table('users')->where('updated','>',time() - $day_time*3)->count();
        $day_4 = $db->table('users')->where('updated','>',time() - $day_time*4)->count();
        $day_5 = $db->table('users')->where('updated','>',time() - $day_time*5)->count();
        $day_10 = $db->table('users')->where('updated','>',time() - $day_time*10)->count();
        $day_30 = $db->table('users')->where('updated','>',time() - $day_time*30)->count();


        $ref_links = [];
        $unic_refs = $db->table('users')->select('ref')->where('ref','!=','0')->groupBy('ref','id')->distinct()->get();
        foreach ($unic_refs as $unic_ref) {
            $ref_links[] = $unic_ref->ref;
            echo $unic_ref->ref."\n";
        }

        $ref_stats = [];

        foreach ($ref_links as $unic_ref) {
            if($unic_ref!='0'){
                $count_users_ref = $db->table('users')->where('ref',$unic_ref)->count();
                echo $db->table('users')->count()."\n\n";
                echo $count_users_ref." - ".$unic_ref."\n\n";
                if($count_users_ref>15){
                    $ref_stats[$count_users_ref] = ['ref'=>$unic_ref,'count'=>$count_users_ref];
                }
            }
        }

        ksort($ref_stats);
        $sort_ref_stats = [];
        foreach ($ref_stats as $ref_stat) {
            $sort_ref_stats[] = $ref_stat;
        }
        $sort_ref_stats = array_reverse($sort_ref_stats);


        $start_time = strtotime(date("m/d/Y H:00:00"));
        echo $start_time."\n\n";
        switch ($type_period){
            case "hours":
                $users_registered = [];
                for($i = 23;$i>=0;$i--){
                    $date = date('H:i',$start_time - ($i+1) * 60*60);
                    $count = $db->table('users')->where('registered',"<",$start_time - $i * 60*60)->where('registered',">",$start_time - ($i+1) * 60*60);
                    if($follow_ref!="all"){
                        $count = $count->where('ref',$follow_ref);
                    }
                    $count = $count->count();
                    $users_registered[] = [
                        'count' => $count,
                        'date' => $date
                    ];
                }
                if($follow_ref!="all") {
                    $all = $db->table('users')->where('ref',$follow_ref)->where('registered',">", $start_time - 24 * 60 * 60)->where('registered','<',$start_time)->count();
                }else{
                    $all = $db->table('users')->where('registered',">", $start_time - 24 * 60 * 60)->where('registered','<',$start_time)->count();
                }
                break;
            case "days":
                $users_registered = [];
                for($i = 6;$i>=0;$i--){
                    $date = date('d.m.Y',$start_time - ($i+1) * 60*60*24);
                    $count = $db->table('users')->where('registered',"<",$start_time - $i * 60*60*24)->where('registered',">",$start_time - ($i+1) * 60*60*24);
                    if($follow_ref!="all"){
                        $count = $count->where('ref',$follow_ref);
                    }
                    $count = $count->count();
                    $users_registered[] = [
                        'count' => $count,
                        'date' => $date
                    ];
                }
                if($follow_ref!="all") {
                    $all = $db->table('users')->where('ref',$follow_ref)->where('registered',">", $start_time - 24 * 60 * 60)->where('registered','<',$start_time)->count();
                }else{
                    $all = $db->table('users')->where('registered',">", $start_time - 24 * 60 * 60)->where('registered','<',$start_time)->count();
                }
                break;
            case "weeks":
                $start_time = strtotime('monday this week');
                $users_registered = [];
                for($i = 3;$i>=0;$i--){
                    $date = date('d.m.Y',$start_time - $i * 60*60*24*7);
                    $count = $db->table('users')->where('registered',"<",$start_time - $i * 60*60*24*7)->where('registered',">",$start_time - ($i+1) * 60*60*24*7);
                    if($follow_ref!="all"){
                        $count = $count->where('ref',$follow_ref);
                    }
                    $count = $count->count();
                    $users_registered[] = [
                        'count' => $count,
                        'date' => $date
                    ];
                }
                if($follow_ref!="all") {
                    $all = $db->table('users')->where('ref',$follow_ref)->where('registered',">", $start_time - 24 * 60 * 60*7)->where('registered','<',$start_time)->count();
                }else{
                    $all = $db->table('users')->where('registered',">", $start_time - 24 * 60 * 60*7)->where('registered','<',$start_time)->count();
                }

                break;
        }

        $chart_data = [
            'type' => $type_period,
            'chart' => $users_registered,
            'all' => $all
        ];

        echo json_encode([
            'count_users'=>$count_users,
            'day_1'=>$day_1,
            'day_2'=>$day_2,
            'day_3'=>$day_3,
            'day_4'=>$day_4,
            'day_5'=>$day_5,
            'day_10'=>$day_10,
            'day_30'=>$day_30,
            'ref_stats' => $sort_ref_stats,
            'chart' => $chart_data
        ]);


    }
}
